/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.datacatalog.model.RecommendationResourceType;
import com.oracle.bmc.datacatalog.model.RecommendationStatus;
import com.oracle.bmc.datacatalog.model.RecommendationType;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.ws.rs.client.Invocation;

public class RecommendationsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private List<RecommendationType> recommendationType;
    private String sourceObjectKey;
    private RecommendationResourceType sourceObjectType;
    private RecommendationStatus recommendationStatus;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "recommendationType", "sourceObjectKey", "sourceObjectType", "recommendationStatus", "opcRequestId"})
    RecommendationsRequest(String catalogId, List<RecommendationType> recommendationType, String sourceObjectKey, RecommendationResourceType sourceObjectType, RecommendationStatus recommendationStatus, String opcRequestId) {
        this.catalogId = catalogId;
        this.recommendationType = recommendationType;
        this.sourceObjectKey = sourceObjectKey;
        this.sourceObjectType = sourceObjectType;
        this.recommendationStatus = recommendationStatus;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public List<RecommendationType> getRecommendationType() {
        return this.recommendationType;
    }

    public String getSourceObjectKey() {
        return this.sourceObjectKey;
    }

    public RecommendationResourceType getSourceObjectType() {
        return this.sourceObjectType;
    }

    public RecommendationStatus getRecommendationStatus() {
        return this.recommendationStatus;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<RecommendationsRequest, Void> {
        private String catalogId;
        private List<RecommendationType> recommendationType;
        private String sourceObjectKey;
        private RecommendationResourceType sourceObjectType;
        private RecommendationStatus recommendationStatus;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RecommendationsRequest o) {
            this.catalogId(o.getCatalogId());
            this.recommendationType(o.getRecommendationType());
            this.sourceObjectKey(o.getSourceObjectKey());
            this.sourceObjectType(o.getSourceObjectType());
            this.recommendationStatus(o.getRecommendationStatus());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RecommendationsRequest build() {
            RecommendationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder recommendationType(List<RecommendationType> recommendationType) {
            this.recommendationType = recommendationType;
            return this;
        }

        public Builder sourceObjectKey(String sourceObjectKey) {
            this.sourceObjectKey = sourceObjectKey;
            return this;
        }

        public Builder sourceObjectType(RecommendationResourceType sourceObjectType) {
            this.sourceObjectType = sourceObjectType;
            return this;
        }

        public Builder recommendationStatus(RecommendationStatus recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public RecommendationsRequest buildWithoutInvocationCallback() {
            return new RecommendationsRequest(this.catalogId, this.recommendationType, this.sourceObjectKey, this.sourceObjectType, this.recommendationStatus, this.opcRequestId);
        }

        public String toString() {
            return "RecommendationsRequest.Builder(catalogId=" + this.catalogId + ", recommendationType=" + this.recommendationType + ", sourceObjectKey=" + this.sourceObjectKey + ", sourceObjectType=" + (Object)((Object)this.sourceObjectType) + ", recommendationStatus=" + (Object)((Object)this.recommendationStatus) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

