/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.UpdateEntityDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateEntityRequest
extends BmcRequest<UpdateEntityDetails> {
    private String catalogId;
    private String dataAssetKey;
    private String entityKey;
    private UpdateEntityDetails updateEntityDetails;
    private String ifMatch;
    private String opcRequestId;

    @InternalSdk
    public UpdateEntityDetails getBody$() {
        return this.updateEntityDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "entityKey", "updateEntityDetails", "ifMatch", "opcRequestId"})
    UpdateEntityRequest(String catalogId, String dataAssetKey, String entityKey, UpdateEntityDetails updateEntityDetails, String ifMatch, String opcRequestId) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.entityKey = entityKey;
        this.updateEntityDetails = updateEntityDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public UpdateEntityDetails getUpdateEntityDetails() {
        return this.updateEntityDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateEntityRequest, UpdateEntityDetails> {
        private String catalogId;
        private String dataAssetKey;
        private String entityKey;
        private UpdateEntityDetails updateEntityDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateEntityRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.entityKey(o.getEntityKey());
            this.updateEntityDetails(o.getUpdateEntityDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateEntityRequest build() {
            UpdateEntityRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateEntityDetails body) {
            this.updateEntityDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder entityKey(String entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public Builder updateEntityDetails(UpdateEntityDetails updateEntityDetails) {
            this.updateEntityDetails = updateEntityDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateEntityRequest buildWithoutInvocationCallback() {
            return new UpdateEntityRequest(this.catalogId, this.dataAssetKey, this.entityKey, this.updateEntityDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateEntityRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", entityKey=" + this.entityKey + ", updateEntityDetails=" + this.updateEntityDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

