/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.UploadCredentialsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UploadCredentialsRequest
extends BmcRequest<UploadCredentialsDetails> {
    private String catalogId;
    private String dataAssetKey;
    private String connectionKey;
    private UploadCredentialsDetails uploadCredentialsDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    @InternalSdk
    public UploadCredentialsDetails getBody$() {
        return this.uploadCredentialsDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "connectionKey", "uploadCredentialsDetails", "opcRequestId", "ifMatch", "opcRetryToken"})
    UploadCredentialsRequest(String catalogId, String dataAssetKey, String connectionKey, UploadCredentialsDetails uploadCredentialsDetails, String opcRequestId, String ifMatch, String opcRetryToken) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.connectionKey = connectionKey;
        this.uploadCredentialsDetails = uploadCredentialsDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public UploadCredentialsDetails getUploadCredentialsDetails() {
        return this.uploadCredentialsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<UploadCredentialsRequest, UploadCredentialsDetails> {
        private String catalogId;
        private String dataAssetKey;
        private String connectionKey;
        private UploadCredentialsDetails uploadCredentialsDetails;
        private String opcRequestId;
        private String ifMatch;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UploadCredentialsRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.connectionKey(o.getConnectionKey());
            this.uploadCredentialsDetails(o.getUploadCredentialsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UploadCredentialsRequest build() {
            UploadCredentialsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UploadCredentialsDetails body) {
            this.uploadCredentialsDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder uploadCredentialsDetails(UploadCredentialsDetails uploadCredentialsDetails) {
            this.uploadCredentialsDetails = uploadCredentialsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public UploadCredentialsRequest buildWithoutInvocationCallback() {
            return new UploadCredentialsRequest(this.catalogId, this.dataAssetKey, this.connectionKey, this.uploadCredentialsDetails, this.opcRequestId, this.ifMatch, this.opcRetryToken);
        }

        public String toString() {
            return "UploadCredentialsRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", connectionKey=" + this.connectionKey + ", uploadCredentialsDetails=" + this.uploadCredentialsDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

