/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.dataflow.DataFlow;
import com.oracle.bmc.dataflow.model.ApplicationLifecycleState;
import com.oracle.bmc.dataflow.model.PrivateEndpointLifecycleState;
import com.oracle.bmc.dataflow.model.RunLifecycleState;
import com.oracle.bmc.dataflow.requests.GetApplicationRequest;
import com.oracle.bmc.dataflow.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.GetRunRequest;
import com.oracle.bmc.dataflow.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataflow.responses.GetApplicationResponse;
import com.oracle.bmc.dataflow.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.GetRunResponse;
import com.oracle.bmc.dataflow.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class DataFlowWaiters {
    private final ExecutorService executorService;
    private final DataFlow client;

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, ApplicationLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forApplication(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, ApplicationLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ApplicationLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(BmcGenericWaiter waiter, GetApplicationRequest request, ApplicationLifecycleState ... targetStates) {
        final HashSet<ApplicationLifecycleState> targetStatesSet = new HashSet<ApplicationLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetApplicationRequest, GetApplicationResponse>(){

            public GetApplicationResponse apply(GetApplicationRequest request) {
                return DataFlowWaiters.this.client.getApplication(request);
            }
        }, (Predicate)new Predicate<GetApplicationResponse>(){

            public boolean apply(GetApplicationResponse response) {
                return targetStatesSet.contains((Object)response.getApplication().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ApplicationLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(GetPrivateEndpointRequest request, PrivateEndpointLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPrivateEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(GetPrivateEndpointRequest request, PrivateEndpointLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(GetPrivateEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PrivateEndpointLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(BmcGenericWaiter waiter, GetPrivateEndpointRequest request, PrivateEndpointLifecycleState ... targetStates) {
        final HashSet<PrivateEndpointLifecycleState> targetStatesSet = new HashSet<PrivateEndpointLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetPrivateEndpointRequest, GetPrivateEndpointResponse>(){

            public GetPrivateEndpointResponse apply(GetPrivateEndpointRequest request) {
                return DataFlowWaiters.this.client.getPrivateEndpoint(request);
            }
        }, (Predicate)new Predicate<GetPrivateEndpointResponse>(){

            public boolean apply(GetPrivateEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getPrivateEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PrivateEndpointLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetRunRequest, GetRunResponse> forRun(GetRunRequest request, RunLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRun(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRunRequest, GetRunResponse> forRun(GetRunRequest request, RunLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRun(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRunRequest, GetRunResponse> forRun(GetRunRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, RunLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRun(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRunRequest, GetRunResponse> forRun(BmcGenericWaiter waiter, GetRunRequest request, RunLifecycleState ... targetStates) {
        final HashSet<RunLifecycleState> targetStatesSet = new HashSet<RunLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetRunRequest, GetRunResponse>(){

            public GetRunResponse apply(GetRunRequest request) {
                return DataFlowWaiters.this.client.getRun(request);
            }
        }, (Predicate)new Predicate<GetRunResponse>(){

            public boolean apply(GetRunResponse response) {
                return targetStatesSet.contains((Object)response.getRun().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DataFlowWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public DataFlowWaiters(ExecutorService executorService, DataFlow client) {
        this.executorService = executorService;
        this.client = client;
    }
}

