/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RunLogSummary {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="runId")
    private final String runId;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="source")
    private final Source source;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="type")
    private final Type type;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().name(this.name).runId(this.runId).sizeInBytes(this.sizeInBytes).source(this.source).timeCreated(this.timeCreated).type(this.type);
    }

    public String getName() {
        return this.name;
    }

    public String getRunId() {
        return this.runId;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Source getSource() {
        return this.source;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Type getType() {
        return this.type;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunLogSummary)) {
            return false;
        }
        RunLogSummary other = (RunLogSummary)o;
        Long this$sizeInBytes = this.getSizeInBytes();
        Long other$sizeInBytes = other.getSizeInBytes();
        if (this$sizeInBytes == null ? other$sizeInBytes != null : !((Object)this$sizeInBytes).equals(other$sizeInBytes)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$runId = this.getRunId();
        String other$runId = other.getRunId();
        if (this$runId == null ? other$runId != null : !this$runId.equals(other$runId)) {
            return false;
        }
        Source this$source = this.getSource();
        Source other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)((Object)this$source)).equals((Object)other$source)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sizeInBytes = this.getSizeInBytes();
        result = result * 59 + ($sizeInBytes == null ? 43 : ((Object)$sizeInBytes).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $runId = this.getRunId();
        result = result * 59 + ($runId == null ? 43 : $runId.hashCode());
        Source $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)((Object)$source)).hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "RunLogSummary(name=" + this.getName() + ", runId=" + this.getRunId() + ", sizeInBytes=" + this.getSizeInBytes() + ", source=" + (Object)((Object)this.getSource()) + ", timeCreated=" + this.getTimeCreated() + ", type=" + (Object)((Object)this.getType()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"name", "runId", "sizeInBytes", "source", "timeCreated", "type"})
    @Deprecated
    public RunLogSummary(String name, String runId, Long sizeInBytes, Source source, Date timeCreated, Type type) {
        this.name = name;
        this.runId = runId;
        this.sizeInBytes = sizeInBytes;
        this.source = source;
        this.timeCreated = timeCreated;
        this.type = type;
    }

    public static enum Type {
        Stderr("STDERR"),
        Stdout("STDOUT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Source {
        Application("APPLICATION"),
        Driver("DRIVER"),
        Executor("EXECUTOR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Source> map;

        private Source(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Source create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Source', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Source.class);
            map = new HashMap<String, Source>();
            for (Source v : Source.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="runId")
        private String runId;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="source")
        private Source source;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="type")
        private Type type;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder runId(String runId) {
            this.runId = runId;
            this.__explicitlySet__.add("runId");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public RunLogSummary build() {
            RunLogSummary __instance__ = new RunLogSummary(this.name, this.runId, this.sizeInBytes, this.source, this.timeCreated, this.type);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(RunLogSummary o) {
            Builder copiedBuilder = this.name(o.getName()).runId(o.getRunId()).sizeInBytes(o.getSizeInBytes()).source(o.getSource()).timeCreated(o.getTimeCreated()).type(o.getType());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "RunLogSummary.Builder(name=" + this.name + ", runId=" + this.runId + ", sizeInBytes=" + this.sizeInBytes + ", source=" + (Object)((Object)this.source) + ", timeCreated=" + this.timeCreated + ", type=" + (Object)((Object)this.type) + ")";
        }
    }
}

