/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPrivateEndpointRequest
extends BmcRequest<Void> {
    private String privateEndpointId;
    private String opcRequestId;

    @ConstructorProperties(value={"privateEndpointId", "opcRequestId"})
    GetPrivateEndpointRequest(String privateEndpointId, String opcRequestId) {
        this.privateEndpointId = privateEndpointId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPrivateEndpointId() {
        return this.privateEndpointId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPrivateEndpointRequest, Void> {
        private String privateEndpointId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPrivateEndpointRequest o) {
            this.privateEndpointId(o.getPrivateEndpointId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPrivateEndpointRequest build() {
            GetPrivateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder privateEndpointId(String privateEndpointId) {
            this.privateEndpointId = privateEndpointId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetPrivateEndpointRequest buildWithoutInvocationCallback() {
            return new GetPrivateEndpointRequest(this.privateEndpointId, this.opcRequestId);
        }

        public String toString() {
            return "GetPrivateEndpointRequest.Builder(privateEndpointId=" + this.privateEndpointId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

