/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datasafe.model.DataSafePrivateEndpoint;
import com.oracle.bmc.datasafe.requests.GetDataSafePrivateEndpointRequest;
import com.oracle.bmc.datasafe.responses.GetDataSafePrivateEndpointResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDataSafePrivateEndpointConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetDataSafePrivateEndpointConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetDataSafePrivateEndpointRequest interceptRequest(GetDataSafePrivateEndpointRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetDataSafePrivateEndpointRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDataSafePrivateEndpointId(), (String)"dataSafePrivateEndpointId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181201").path("dataSafePrivateEndpoints").path(HttpUtils.encodePathSegment((String)request.getDataSafePrivateEndpointId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetDataSafePrivateEndpointResponse> fromResponse() {
        Function<Response, GetDataSafePrivateEndpointResponse> transformer = new Function<Response, GetDataSafePrivateEndpointResponse>(){

            public GetDataSafePrivateEndpointResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datasafe.responses.GetDataSafePrivateEndpointResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DataSafePrivateEndpoint.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetDataSafePrivateEndpointResponse.Builder builder = GetDataSafePrivateEndpointResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.dataSafePrivateEndpoint((DataSafePrivateEndpoint)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetDataSafePrivateEndpointResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

