/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.dts.ApplianceExportJob;
import com.oracle.bmc.dts.model.ApplianceExportJob;
import com.oracle.bmc.dts.requests.GetApplianceExportJobRequest;
import com.oracle.bmc.dts.responses.GetApplianceExportJobResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class ApplianceExportJobWaiters {
    private final ExecutorService executorService;
    private final ApplianceExportJob client;

    public Waiter<GetApplianceExportJobRequest, GetApplianceExportJobResponse> forApplianceExportJob(GetApplianceExportJobRequest request, ApplianceExportJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forApplianceExportJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetApplianceExportJobRequest, GetApplianceExportJobResponse> forApplianceExportJob(GetApplianceExportJobRequest request, ApplianceExportJob.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forApplianceExportJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetApplianceExportJobRequest, GetApplianceExportJobResponse> forApplianceExportJob(GetApplianceExportJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ApplianceExportJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forApplianceExportJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetApplianceExportJobRequest, GetApplianceExportJobResponse> forApplianceExportJob(BmcGenericWaiter waiter, GetApplianceExportJobRequest request, ApplianceExportJob.LifecycleState ... targetStates) {
        final HashSet<ApplianceExportJob.LifecycleState> targetStatesSet = new HashSet<ApplianceExportJob.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetApplianceExportJobRequest, GetApplianceExportJobResponse>(){

            public GetApplianceExportJobResponse apply(GetApplianceExportJobRequest request) {
                return ApplianceExportJobWaiters.this.client.getApplianceExportJob(request);
            }
        }, (Predicate)new Predicate<GetApplianceExportJobResponse>(){

            public boolean apply(GetApplianceExportJobResponse response) {
                return targetStatesSet.contains((Object)response.getApplianceExportJob().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ApplianceExportJob.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public ApplianceExportJobWaiters(ExecutorService executorService, ApplianceExportJob client) {
        this.executorService = executorService;
        this.client = client;
    }
}

