/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferApplianceAsync;
import com.oracle.bmc.dts.internal.http.CreateTransferApplianceAdminCredentialsConverter;
import com.oracle.bmc.dts.internal.http.CreateTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.DeleteTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceCertificateAuthorityCertificateConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceEncryptionPassphraseConverter;
import com.oracle.bmc.dts.internal.http.ListTransferAppliancesConverter;
import com.oracle.bmc.dts.internal.http.UpdateTransferApplianceConverter;
import com.oracle.bmc.dts.requests.CreateTransferApplianceAdminCredentialsRequest;
import com.oracle.bmc.dts.requests.CreateTransferApplianceRequest;
import com.oracle.bmc.dts.requests.DeleteTransferApplianceRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceCertificateAuthorityCertificateRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceEncryptionPassphraseRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceRequest;
import com.oracle.bmc.dts.requests.ListTransferAppliancesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferApplianceRequest;
import com.oracle.bmc.dts.responses.CreateTransferApplianceAdminCredentialsResponse;
import com.oracle.bmc.dts.responses.CreateTransferApplianceResponse;
import com.oracle.bmc.dts.responses.DeleteTransferApplianceResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceCertificateAuthorityCertificateResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceEncryptionPassphraseResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceResponse;
import com.oracle.bmc.dts.responses.ListTransferAppliancesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferApplianceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferApplianceAsyncClient
implements TransferApplianceAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TransferApplianceAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERAPPLIANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public TransferApplianceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public TransferApplianceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public TransferApplianceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateTransferApplianceResponse> createTransferAppliance(CreateTransferApplianceRequest request, AsyncHandler<CreateTransferApplianceRequest, CreateTransferApplianceResponse> handler) {
        LOG.trace("Called async createTransferAppliance");
        CreateTransferApplianceRequest interceptedRequest = CreateTransferApplianceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTransferApplianceResponse> transformer = CreateTransferApplianceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTransferApplianceRequest, CreateTransferApplianceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTransferApplianceRequest, CreateTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTransferApplianceAdminCredentialsResponse> createTransferApplianceAdminCredentials(CreateTransferApplianceAdminCredentialsRequest request, AsyncHandler<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse> handler) {
        LOG.trace("Called async createTransferApplianceAdminCredentials");
        CreateTransferApplianceAdminCredentialsRequest interceptedRequest = CreateTransferApplianceAdminCredentialsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTransferApplianceAdminCredentialsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTransferApplianceAdminCredentialsResponse> transformer = CreateTransferApplianceAdminCredentialsConverter.fromResponse();
        AsyncHandler<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTransferApplianceResponse> deleteTransferAppliance(DeleteTransferApplianceRequest request, AsyncHandler<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse> handler) {
        LOG.trace("Called async deleteTransferAppliance");
        DeleteTransferApplianceRequest interceptedRequest = DeleteTransferApplianceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTransferApplianceResponse> transformer = DeleteTransferApplianceConverter.fromResponse();
        AsyncHandler<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTransferApplianceResponse> getTransferAppliance(GetTransferApplianceRequest request, AsyncHandler<GetTransferApplianceRequest, GetTransferApplianceResponse> handler) {
        LOG.trace("Called async getTransferAppliance");
        GetTransferApplianceRequest interceptedRequest = GetTransferApplianceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTransferApplianceResponse> transformer = GetTransferApplianceConverter.fromResponse();
        AsyncHandler<GetTransferApplianceRequest, GetTransferApplianceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTransferApplianceRequest, GetTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTransferApplianceCertificateAuthorityCertificateResponse> getTransferApplianceCertificateAuthorityCertificate(GetTransferApplianceCertificateAuthorityCertificateRequest request, AsyncHandler<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse> handler) {
        LOG.trace("Called async getTransferApplianceCertificateAuthorityCertificate");
        GetTransferApplianceCertificateAuthorityCertificateRequest interceptedRequest = GetTransferApplianceCertificateAuthorityCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTransferApplianceCertificateAuthorityCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTransferApplianceCertificateAuthorityCertificateResponse> transformer = GetTransferApplianceCertificateAuthorityCertificateConverter.fromResponse();
        AsyncHandler<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTransferApplianceEncryptionPassphraseResponse> getTransferApplianceEncryptionPassphrase(GetTransferApplianceEncryptionPassphraseRequest request, AsyncHandler<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse> handler) {
        LOG.trace("Called async getTransferApplianceEncryptionPassphrase");
        GetTransferApplianceEncryptionPassphraseRequest interceptedRequest = GetTransferApplianceEncryptionPassphraseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTransferApplianceEncryptionPassphraseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTransferApplianceEncryptionPassphraseResponse> transformer = GetTransferApplianceEncryptionPassphraseConverter.fromResponse();
        AsyncHandler<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTransferAppliancesResponse> listTransferAppliances(ListTransferAppliancesRequest request, AsyncHandler<ListTransferAppliancesRequest, ListTransferAppliancesResponse> handler) {
        LOG.trace("Called async listTransferAppliances");
        ListTransferAppliancesRequest interceptedRequest = ListTransferAppliancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTransferAppliancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTransferAppliancesResponse> transformer = ListTransferAppliancesConverter.fromResponse();
        AsyncHandler<ListTransferAppliancesRequest, ListTransferAppliancesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTransferAppliancesRequest, ListTransferAppliancesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTransferApplianceResponse> updateTransferAppliance(UpdateTransferApplianceRequest request, AsyncHandler<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse> handler) {
        LOG.trace("Called async updateTransferAppliance");
        UpdateTransferApplianceRequest interceptedRequest = UpdateTransferApplianceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTransferApplianceResponse> transformer = UpdateTransferApplianceConverter.fromResponse();
        AsyncHandler<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferApplianceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public TransferApplianceAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new TransferApplianceAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

