/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.filestorage.FileStorageAsync;
import com.oracle.bmc.filestorage.internal.http.ChangeFileSystemCompartmentConverter;
import com.oracle.bmc.filestorage.internal.http.ChangeMountTargetCompartmentConverter;
import com.oracle.bmc.filestorage.internal.http.CreateExportConverter;
import com.oracle.bmc.filestorage.internal.http.CreateFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.CreateMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.CreateSnapshotConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteExportConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteSnapshotConverter;
import com.oracle.bmc.filestorage.internal.http.GetExportConverter;
import com.oracle.bmc.filestorage.internal.http.GetExportSetConverter;
import com.oracle.bmc.filestorage.internal.http.GetFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.GetMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.GetSnapshotConverter;
import com.oracle.bmc.filestorage.internal.http.ListExportSetsConverter;
import com.oracle.bmc.filestorage.internal.http.ListExportsConverter;
import com.oracle.bmc.filestorage.internal.http.ListFileSystemsConverter;
import com.oracle.bmc.filestorage.internal.http.ListMountTargetsConverter;
import com.oracle.bmc.filestorage.internal.http.ListSnapshotsConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateExportConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateExportSetConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateSnapshotConverter;
import com.oracle.bmc.filestorage.requests.ChangeFileSystemCompartmentRequest;
import com.oracle.bmc.filestorage.requests.ChangeMountTargetCompartmentRequest;
import com.oracle.bmc.filestorage.requests.CreateExportRequest;
import com.oracle.bmc.filestorage.requests.CreateFileSystemRequest;
import com.oracle.bmc.filestorage.requests.CreateMountTargetRequest;
import com.oracle.bmc.filestorage.requests.CreateSnapshotRequest;
import com.oracle.bmc.filestorage.requests.DeleteExportRequest;
import com.oracle.bmc.filestorage.requests.DeleteFileSystemRequest;
import com.oracle.bmc.filestorage.requests.DeleteMountTargetRequest;
import com.oracle.bmc.filestorage.requests.DeleteSnapshotRequest;
import com.oracle.bmc.filestorage.requests.GetExportRequest;
import com.oracle.bmc.filestorage.requests.GetExportSetRequest;
import com.oracle.bmc.filestorage.requests.GetFileSystemRequest;
import com.oracle.bmc.filestorage.requests.GetMountTargetRequest;
import com.oracle.bmc.filestorage.requests.GetSnapshotRequest;
import com.oracle.bmc.filestorage.requests.ListExportSetsRequest;
import com.oracle.bmc.filestorage.requests.ListExportsRequest;
import com.oracle.bmc.filestorage.requests.ListFileSystemsRequest;
import com.oracle.bmc.filestorage.requests.ListMountTargetsRequest;
import com.oracle.bmc.filestorage.requests.ListSnapshotsRequest;
import com.oracle.bmc.filestorage.requests.UpdateExportRequest;
import com.oracle.bmc.filestorage.requests.UpdateExportSetRequest;
import com.oracle.bmc.filestorage.requests.UpdateFileSystemRequest;
import com.oracle.bmc.filestorage.requests.UpdateMountTargetRequest;
import com.oracle.bmc.filestorage.requests.UpdateSnapshotRequest;
import com.oracle.bmc.filestorage.responses.ChangeFileSystemCompartmentResponse;
import com.oracle.bmc.filestorage.responses.ChangeMountTargetCompartmentResponse;
import com.oracle.bmc.filestorage.responses.CreateExportResponse;
import com.oracle.bmc.filestorage.responses.CreateFileSystemResponse;
import com.oracle.bmc.filestorage.responses.CreateMountTargetResponse;
import com.oracle.bmc.filestorage.responses.CreateSnapshotResponse;
import com.oracle.bmc.filestorage.responses.DeleteExportResponse;
import com.oracle.bmc.filestorage.responses.DeleteFileSystemResponse;
import com.oracle.bmc.filestorage.responses.DeleteMountTargetResponse;
import com.oracle.bmc.filestorage.responses.DeleteSnapshotResponse;
import com.oracle.bmc.filestorage.responses.GetExportResponse;
import com.oracle.bmc.filestorage.responses.GetExportSetResponse;
import com.oracle.bmc.filestorage.responses.GetFileSystemResponse;
import com.oracle.bmc.filestorage.responses.GetMountTargetResponse;
import com.oracle.bmc.filestorage.responses.GetSnapshotResponse;
import com.oracle.bmc.filestorage.responses.ListExportSetsResponse;
import com.oracle.bmc.filestorage.responses.ListExportsResponse;
import com.oracle.bmc.filestorage.responses.ListFileSystemsResponse;
import com.oracle.bmc.filestorage.responses.ListMountTargetsResponse;
import com.oracle.bmc.filestorage.responses.ListSnapshotsResponse;
import com.oracle.bmc.filestorage.responses.UpdateExportResponse;
import com.oracle.bmc.filestorage.responses.UpdateExportSetResponse;
import com.oracle.bmc.filestorage.responses.UpdateFileSystemResponse;
import com.oracle.bmc.filestorage.responses.UpdateMountTargetResponse;
import com.oracle.bmc.filestorage.responses.UpdateSnapshotResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageAsyncClient
implements FileStorageAsync {
    private static final Logger LOG = LoggerFactory.getLogger(FileStorageAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FILESTORAGE").serviceEndpointPrefix("filestorage").serviceEndpointTemplate("https://filestorage.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public FileStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public FileStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public FileStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public FileStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public FileStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public FileStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public FileStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public FileStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeFileSystemCompartmentResponse> changeFileSystemCompartment(ChangeFileSystemCompartmentRequest request, AsyncHandler<ChangeFileSystemCompartmentRequest, ChangeFileSystemCompartmentResponse> handler) {
        LOG.trace("Called async changeFileSystemCompartment");
        ChangeFileSystemCompartmentRequest interceptedRequest = ChangeFileSystemCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeFileSystemCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeFileSystemCompartmentResponse> transformer = ChangeFileSystemCompartmentConverter.fromResponse();
        AsyncHandler<ChangeFileSystemCompartmentRequest, ChangeFileSystemCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeFileSystemCompartmentRequest, ChangeFileSystemCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeMountTargetCompartmentResponse> changeMountTargetCompartment(ChangeMountTargetCompartmentRequest request, AsyncHandler<ChangeMountTargetCompartmentRequest, ChangeMountTargetCompartmentResponse> handler) {
        LOG.trace("Called async changeMountTargetCompartment");
        ChangeMountTargetCompartmentRequest interceptedRequest = ChangeMountTargetCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeMountTargetCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeMountTargetCompartmentResponse> transformer = ChangeMountTargetCompartmentConverter.fromResponse();
        AsyncHandler<ChangeMountTargetCompartmentRequest, ChangeMountTargetCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeMountTargetCompartmentRequest, ChangeMountTargetCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateExportResponse> createExport(CreateExportRequest request, AsyncHandler<CreateExportRequest, CreateExportResponse> handler) {
        LOG.trace("Called async createExport");
        CreateExportRequest interceptedRequest = CreateExportConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateExportConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateExportResponse> transformer = CreateExportConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateExportRequest, CreateExportResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateExportRequest, CreateExportResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateFileSystemResponse> createFileSystem(CreateFileSystemRequest request, AsyncHandler<CreateFileSystemRequest, CreateFileSystemResponse> handler) {
        LOG.trace("Called async createFileSystem");
        CreateFileSystemRequest interceptedRequest = CreateFileSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateFileSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateFileSystemResponse> transformer = CreateFileSystemConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateFileSystemRequest, CreateFileSystemResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateFileSystemRequest, CreateFileSystemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateMountTargetResponse> createMountTarget(CreateMountTargetRequest request, AsyncHandler<CreateMountTargetRequest, CreateMountTargetResponse> handler) {
        LOG.trace("Called async createMountTarget");
        CreateMountTargetRequest interceptedRequest = CreateMountTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateMountTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateMountTargetResponse> transformer = CreateMountTargetConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateMountTargetRequest, CreateMountTargetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateMountTargetRequest, CreateMountTargetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest request, AsyncHandler<CreateSnapshotRequest, CreateSnapshotResponse> handler) {
        LOG.trace("Called async createSnapshot");
        CreateSnapshotRequest interceptedRequest = CreateSnapshotConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSnapshotConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSnapshotResponse> transformer = CreateSnapshotConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateSnapshotRequest, CreateSnapshotResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSnapshotRequest, CreateSnapshotResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteExportResponse> deleteExport(DeleteExportRequest request, AsyncHandler<DeleteExportRequest, DeleteExportResponse> handler) {
        LOG.trace("Called async deleteExport");
        DeleteExportRequest interceptedRequest = DeleteExportConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteExportConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteExportResponse> transformer = DeleteExportConverter.fromResponse();
        AsyncHandler<DeleteExportRequest, DeleteExportResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteExportRequest, DeleteExportResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteFileSystemResponse> deleteFileSystem(DeleteFileSystemRequest request, AsyncHandler<DeleteFileSystemRequest, DeleteFileSystemResponse> handler) {
        LOG.trace("Called async deleteFileSystem");
        DeleteFileSystemRequest interceptedRequest = DeleteFileSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFileSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteFileSystemResponse> transformer = DeleteFileSystemConverter.fromResponse();
        AsyncHandler<DeleteFileSystemRequest, DeleteFileSystemResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteFileSystemRequest, DeleteFileSystemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteMountTargetResponse> deleteMountTarget(DeleteMountTargetRequest request, AsyncHandler<DeleteMountTargetRequest, DeleteMountTargetResponse> handler) {
        LOG.trace("Called async deleteMountTarget");
        DeleteMountTargetRequest interceptedRequest = DeleteMountTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteMountTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteMountTargetResponse> transformer = DeleteMountTargetConverter.fromResponse();
        AsyncHandler<DeleteMountTargetRequest, DeleteMountTargetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteMountTargetRequest, DeleteMountTargetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest request, AsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResponse> handler) {
        LOG.trace("Called async deleteSnapshot");
        DeleteSnapshotRequest interceptedRequest = DeleteSnapshotConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSnapshotConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSnapshotResponse> transformer = DeleteSnapshotConverter.fromResponse();
        AsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSnapshotRequest, DeleteSnapshotResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetExportResponse> getExport(GetExportRequest request, AsyncHandler<GetExportRequest, GetExportResponse> handler) {
        LOG.trace("Called async getExport");
        GetExportRequest interceptedRequest = GetExportConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExportConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetExportResponse> transformer = GetExportConverter.fromResponse();
        AsyncHandler<GetExportRequest, GetExportResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetExportRequest, GetExportResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetExportSetResponse> getExportSet(GetExportSetRequest request, AsyncHandler<GetExportSetRequest, GetExportSetResponse> handler) {
        LOG.trace("Called async getExportSet");
        GetExportSetRequest interceptedRequest = GetExportSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExportSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetExportSetResponse> transformer = GetExportSetConverter.fromResponse();
        AsyncHandler<GetExportSetRequest, GetExportSetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetExportSetRequest, GetExportSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetFileSystemResponse> getFileSystem(GetFileSystemRequest request, AsyncHandler<GetFileSystemRequest, GetFileSystemResponse> handler) {
        LOG.trace("Called async getFileSystem");
        GetFileSystemRequest interceptedRequest = GetFileSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFileSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFileSystemResponse> transformer = GetFileSystemConverter.fromResponse();
        AsyncHandler<GetFileSystemRequest, GetFileSystemResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetFileSystemRequest, GetFileSystemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetMountTargetResponse> getMountTarget(GetMountTargetRequest request, AsyncHandler<GetMountTargetRequest, GetMountTargetResponse> handler) {
        LOG.trace("Called async getMountTarget");
        GetMountTargetRequest interceptedRequest = GetMountTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMountTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetMountTargetResponse> transformer = GetMountTargetConverter.fromResponse();
        AsyncHandler<GetMountTargetRequest, GetMountTargetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetMountTargetRequest, GetMountTargetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSnapshotResponse> getSnapshot(GetSnapshotRequest request, AsyncHandler<GetSnapshotRequest, GetSnapshotResponse> handler) {
        LOG.trace("Called async getSnapshot");
        GetSnapshotRequest interceptedRequest = GetSnapshotConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSnapshotConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSnapshotResponse> transformer = GetSnapshotConverter.fromResponse();
        AsyncHandler<GetSnapshotRequest, GetSnapshotResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSnapshotRequest, GetSnapshotResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListExportSetsResponse> listExportSets(ListExportSetsRequest request, AsyncHandler<ListExportSetsRequest, ListExportSetsResponse> handler) {
        LOG.trace("Called async listExportSets");
        ListExportSetsRequest interceptedRequest = ListExportSetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListExportSetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListExportSetsResponse> transformer = ListExportSetsConverter.fromResponse();
        AsyncHandler<ListExportSetsRequest, ListExportSetsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListExportSetsRequest, ListExportSetsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListExportsResponse> listExports(ListExportsRequest request, AsyncHandler<ListExportsRequest, ListExportsResponse> handler) {
        LOG.trace("Called async listExports");
        ListExportsRequest interceptedRequest = ListExportsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListExportsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListExportsResponse> transformer = ListExportsConverter.fromResponse();
        AsyncHandler<ListExportsRequest, ListExportsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListExportsRequest, ListExportsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListFileSystemsResponse> listFileSystems(ListFileSystemsRequest request, AsyncHandler<ListFileSystemsRequest, ListFileSystemsResponse> handler) {
        LOG.trace("Called async listFileSystems");
        ListFileSystemsRequest interceptedRequest = ListFileSystemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFileSystemsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListFileSystemsResponse> transformer = ListFileSystemsConverter.fromResponse();
        AsyncHandler<ListFileSystemsRequest, ListFileSystemsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListFileSystemsRequest, ListFileSystemsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListMountTargetsResponse> listMountTargets(ListMountTargetsRequest request, AsyncHandler<ListMountTargetsRequest, ListMountTargetsResponse> handler) {
        LOG.trace("Called async listMountTargets");
        ListMountTargetsRequest interceptedRequest = ListMountTargetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMountTargetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMountTargetsResponse> transformer = ListMountTargetsConverter.fromResponse();
        AsyncHandler<ListMountTargetsRequest, ListMountTargetsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListMountTargetsRequest, ListMountTargetsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSnapshotsResponse> listSnapshots(ListSnapshotsRequest request, AsyncHandler<ListSnapshotsRequest, ListSnapshotsResponse> handler) {
        LOG.trace("Called async listSnapshots");
        ListSnapshotsRequest interceptedRequest = ListSnapshotsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSnapshotsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSnapshotsResponse> transformer = ListSnapshotsConverter.fromResponse();
        AsyncHandler<ListSnapshotsRequest, ListSnapshotsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSnapshotsRequest, ListSnapshotsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateExportResponse> updateExport(UpdateExportRequest request, AsyncHandler<UpdateExportRequest, UpdateExportResponse> handler) {
        LOG.trace("Called async updateExport");
        UpdateExportRequest interceptedRequest = UpdateExportConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateExportConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateExportResponse> transformer = UpdateExportConverter.fromResponse();
        AsyncHandler<UpdateExportRequest, UpdateExportResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateExportRequest, UpdateExportResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateExportSetResponse> updateExportSet(UpdateExportSetRequest request, AsyncHandler<UpdateExportSetRequest, UpdateExportSetResponse> handler) {
        LOG.trace("Called async updateExportSet");
        UpdateExportSetRequest interceptedRequest = UpdateExportSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateExportSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateExportSetResponse> transformer = UpdateExportSetConverter.fromResponse();
        AsyncHandler<UpdateExportSetRequest, UpdateExportSetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateExportSetRequest, UpdateExportSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateFileSystemResponse> updateFileSystem(UpdateFileSystemRequest request, AsyncHandler<UpdateFileSystemRequest, UpdateFileSystemResponse> handler) {
        LOG.trace("Called async updateFileSystem");
        UpdateFileSystemRequest interceptedRequest = UpdateFileSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateFileSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateFileSystemResponse> transformer = UpdateFileSystemConverter.fromResponse();
        AsyncHandler<UpdateFileSystemRequest, UpdateFileSystemResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateFileSystemRequest, UpdateFileSystemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateMountTargetResponse> updateMountTarget(UpdateMountTargetRequest request, AsyncHandler<UpdateMountTargetRequest, UpdateMountTargetResponse> handler) {
        LOG.trace("Called async updateMountTarget");
        UpdateMountTargetRequest interceptedRequest = UpdateMountTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateMountTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateMountTargetResponse> transformer = UpdateMountTargetConverter.fromResponse();
        AsyncHandler<UpdateMountTargetRequest, UpdateMountTargetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateMountTargetRequest, UpdateMountTargetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateSnapshotResponse> updateSnapshot(UpdateSnapshotRequest request, AsyncHandler<UpdateSnapshotRequest, UpdateSnapshotResponse> handler) {
        LOG.trace("Called async updateSnapshot");
        UpdateSnapshotRequest interceptedRequest = UpdateSnapshotConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSnapshotConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSnapshotResponse> transformer = UpdateSnapshotConverter.fromResponse();
        AsyncHandler<UpdateSnapshotRequest, UpdateSnapshotResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateSnapshotRequest, UpdateSnapshotResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FileStorageAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public FileStorageAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new FileStorageAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

