/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.filestorage.FileStorage;
import com.oracle.bmc.filestorage.model.Export;
import com.oracle.bmc.filestorage.model.ExportSet;
import com.oracle.bmc.filestorage.model.FileSystem;
import com.oracle.bmc.filestorage.model.MountTarget;
import com.oracle.bmc.filestorage.model.Snapshot;
import com.oracle.bmc.filestorage.requests.GetExportRequest;
import com.oracle.bmc.filestorage.requests.GetExportSetRequest;
import com.oracle.bmc.filestorage.requests.GetFileSystemRequest;
import com.oracle.bmc.filestorage.requests.GetMountTargetRequest;
import com.oracle.bmc.filestorage.requests.GetSnapshotRequest;
import com.oracle.bmc.filestorage.responses.GetExportResponse;
import com.oracle.bmc.filestorage.responses.GetExportSetResponse;
import com.oracle.bmc.filestorage.responses.GetFileSystemResponse;
import com.oracle.bmc.filestorage.responses.GetMountTargetResponse;
import com.oracle.bmc.filestorage.responses.GetSnapshotResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class FileStorageWaiters {
    private final ExecutorService executorService;
    private final FileStorage client;

    public Waiter<GetExportRequest, GetExportResponse> forExport(GetExportRequest request, Export.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExport(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExportRequest, GetExportResponse> forExport(GetExportRequest request, Export.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExportRequest, GetExportResponse> forExport(GetExportRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Export.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExport(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExportRequest, GetExportResponse> forExport(BmcGenericWaiter waiter, GetExportRequest request, Export.LifecycleState ... targetStates) {
        final HashSet<Export.LifecycleState> targetStatesSet = new HashSet<Export.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetExportRequest, GetExportResponse>(){

            public GetExportResponse apply(GetExportRequest request) {
                return FileStorageWaiters.this.client.getExport(request);
            }
        }, (Predicate)new Predicate<GetExportResponse>(){

            public boolean apply(GetExportResponse response) {
                return targetStatesSet.contains((Object)response.getExport().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Export.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetExportSetRequest, GetExportSetResponse> forExportSet(GetExportSetRequest request, ExportSet.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExportSet(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExportSetRequest, GetExportSetResponse> forExportSet(GetExportSetRequest request, ExportSet.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExportSet(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExportSetRequest, GetExportSetResponse> forExportSet(GetExportSetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExportSet.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExportSet(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExportSetRequest, GetExportSetResponse> forExportSet(BmcGenericWaiter waiter, GetExportSetRequest request, ExportSet.LifecycleState ... targetStates) {
        final HashSet<ExportSet.LifecycleState> targetStatesSet = new HashSet<ExportSet.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetExportSetRequest, GetExportSetResponse>(){

            public GetExportSetResponse apply(GetExportSetRequest request) {
                return FileStorageWaiters.this.client.getExportSet(request);
            }
        }, (Predicate)new Predicate<GetExportSetResponse>(){

            public boolean apply(GetExportSetResponse response) {
                return targetStatesSet.contains((Object)response.getExportSet().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExportSet.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetFileSystemRequest, GetFileSystemResponse> forFileSystem(GetFileSystemRequest request, FileSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFileSystem(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFileSystemRequest, GetFileSystemResponse> forFileSystem(GetFileSystemRequest request, FileSystem.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFileSystem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFileSystemRequest, GetFileSystemResponse> forFileSystem(GetFileSystemRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, FileSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forFileSystem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFileSystemRequest, GetFileSystemResponse> forFileSystem(BmcGenericWaiter waiter, GetFileSystemRequest request, FileSystem.LifecycleState ... targetStates) {
        final HashSet<FileSystem.LifecycleState> targetStatesSet = new HashSet<FileSystem.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetFileSystemRequest, GetFileSystemResponse>(){

            public GetFileSystemResponse apply(GetFileSystemRequest request) {
                return FileStorageWaiters.this.client.getFileSystem(request);
            }
        }, (Predicate)new Predicate<GetFileSystemResponse>(){

            public boolean apply(GetFileSystemResponse response) {
                return targetStatesSet.contains((Object)response.getFileSystem().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)FileSystem.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetMountTargetRequest, GetMountTargetResponse> forMountTarget(GetMountTargetRequest request, MountTarget.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMountTarget(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMountTargetRequest, GetMountTargetResponse> forMountTarget(GetMountTargetRequest request, MountTarget.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMountTarget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMountTargetRequest, GetMountTargetResponse> forMountTarget(GetMountTargetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MountTarget.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMountTarget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMountTargetRequest, GetMountTargetResponse> forMountTarget(BmcGenericWaiter waiter, GetMountTargetRequest request, MountTarget.LifecycleState ... targetStates) {
        final HashSet<MountTarget.LifecycleState> targetStatesSet = new HashSet<MountTarget.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetMountTargetRequest, GetMountTargetResponse>(){

            public GetMountTargetResponse apply(GetMountTargetRequest request) {
                return FileStorageWaiters.this.client.getMountTarget(request);
            }
        }, (Predicate)new Predicate<GetMountTargetResponse>(){

            public boolean apply(GetMountTargetResponse response) {
                return targetStatesSet.contains((Object)response.getMountTarget().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MountTarget.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSnapshotRequest, GetSnapshotResponse> forSnapshot(GetSnapshotRequest request, Snapshot.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSnapshot(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSnapshotRequest, GetSnapshotResponse> forSnapshot(GetSnapshotRequest request, Snapshot.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSnapshot(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSnapshotRequest, GetSnapshotResponse> forSnapshot(GetSnapshotRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Snapshot.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSnapshot(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSnapshotRequest, GetSnapshotResponse> forSnapshot(BmcGenericWaiter waiter, GetSnapshotRequest request, Snapshot.LifecycleState ... targetStates) {
        final HashSet<Snapshot.LifecycleState> targetStatesSet = new HashSet<Snapshot.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetSnapshotRequest, GetSnapshotResponse>(){

            public GetSnapshotResponse apply(GetSnapshotRequest request) {
                return FileStorageWaiters.this.client.getSnapshot(request);
            }
        }, (Predicate)new Predicate<GetSnapshotResponse>(){

            public boolean apply(GetSnapshotResponse response) {
                return targetStatesSet.contains((Object)response.getSnapshot().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Snapshot.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public FileStorageWaiters(ExecutorService executorService, FileStorage client) {
        this.executorService = executorService;
        this.client = client;
    }
}

