/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteSnapshotRequest
extends BmcRequest<Void> {
    private String snapshotId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"snapshotId", "ifMatch", "opcRequestId"})
    DeleteSnapshotRequest(String snapshotId, String ifMatch, String opcRequestId) {
        this.snapshotId = snapshotId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteSnapshotRequest, Void> {
        private String snapshotId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteSnapshotRequest o) {
            this.snapshotId(o.getSnapshotId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteSnapshotRequest build() {
            DeleteSnapshotRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteSnapshotRequest buildWithoutInvocationCallback() {
            return new DeleteSnapshotRequest(this.snapshotId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteSnapshotRequest.Builder(snapshotId=" + this.snapshotId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

