/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetExportSetRequest
extends BmcRequest<Void> {
    private String exportSetId;
    private String opcRequestId;

    @ConstructorProperties(value={"exportSetId", "opcRequestId"})
    GetExportSetRequest(String exportSetId, String opcRequestId) {
        this.exportSetId = exportSetId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getExportSetId() {
        return this.exportSetId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExportSetRequest, Void> {
        private String exportSetId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExportSetRequest o) {
            this.exportSetId(o.getExportSetId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExportSetRequest build() {
            GetExportSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder exportSetId(String exportSetId) {
            this.exportSetId = exportSetId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetExportSetRequest buildWithoutInvocationCallback() {
            return new GetExportSetRequest(this.exportSetId, this.opcRequestId);
        }

        public String toString() {
            return "GetExportSetRequest.Builder(exportSetId=" + this.exportSetId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

