/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.functions.FunctionsManagementAsync;
import com.oracle.bmc.functions.internal.http.ChangeApplicationCompartmentConverter;
import com.oracle.bmc.functions.internal.http.CreateApplicationConverter;
import com.oracle.bmc.functions.internal.http.CreateFunctionConverter;
import com.oracle.bmc.functions.internal.http.DeleteApplicationConverter;
import com.oracle.bmc.functions.internal.http.DeleteFunctionConverter;
import com.oracle.bmc.functions.internal.http.GetApplicationConverter;
import com.oracle.bmc.functions.internal.http.GetFunctionConverter;
import com.oracle.bmc.functions.internal.http.ListApplicationsConverter;
import com.oracle.bmc.functions.internal.http.ListFunctionsConverter;
import com.oracle.bmc.functions.internal.http.UpdateApplicationConverter;
import com.oracle.bmc.functions.internal.http.UpdateFunctionConverter;
import com.oracle.bmc.functions.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.functions.requests.CreateApplicationRequest;
import com.oracle.bmc.functions.requests.CreateFunctionRequest;
import com.oracle.bmc.functions.requests.DeleteApplicationRequest;
import com.oracle.bmc.functions.requests.DeleteFunctionRequest;
import com.oracle.bmc.functions.requests.GetApplicationRequest;
import com.oracle.bmc.functions.requests.GetFunctionRequest;
import com.oracle.bmc.functions.requests.ListApplicationsRequest;
import com.oracle.bmc.functions.requests.ListFunctionsRequest;
import com.oracle.bmc.functions.requests.UpdateApplicationRequest;
import com.oracle.bmc.functions.requests.UpdateFunctionRequest;
import com.oracle.bmc.functions.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.functions.responses.CreateApplicationResponse;
import com.oracle.bmc.functions.responses.CreateFunctionResponse;
import com.oracle.bmc.functions.responses.DeleteApplicationResponse;
import com.oracle.bmc.functions.responses.DeleteFunctionResponse;
import com.oracle.bmc.functions.responses.GetApplicationResponse;
import com.oracle.bmc.functions.responses.GetFunctionResponse;
import com.oracle.bmc.functions.responses.ListApplicationsResponse;
import com.oracle.bmc.functions.responses.ListFunctionsResponse;
import com.oracle.bmc.functions.responses.UpdateApplicationResponse;
import com.oracle.bmc.functions.responses.UpdateFunctionResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsManagementAsyncClient
implements FunctionsManagementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionsManagementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FUNCTIONSMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://functions.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public FunctionsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public FunctionsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public FunctionsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeApplicationCompartmentResponse> changeApplicationCompartment(ChangeApplicationCompartmentRequest request, AsyncHandler<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse> handler) {
        LOG.trace("Called async changeApplicationCompartment");
        ChangeApplicationCompartmentRequest interceptedRequest = ChangeApplicationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeApplicationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeApplicationCompartmentResponse> transformer = ChangeApplicationCompartmentConverter.fromResponse();
        AsyncHandler<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateApplicationResponse> createApplication(CreateApplicationRequest request, AsyncHandler<CreateApplicationRequest, CreateApplicationResponse> handler) {
        LOG.trace("Called async createApplication");
        CreateApplicationRequest interceptedRequest = CreateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateApplicationResponse> transformer = CreateApplicationConverter.fromResponse();
        AsyncHandler<CreateApplicationRequest, CreateApplicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateApplicationRequest, CreateApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateFunctionResponse> createFunction(CreateFunctionRequest request, AsyncHandler<CreateFunctionRequest, CreateFunctionResponse> handler) {
        LOG.trace("Called async createFunction");
        CreateFunctionRequest interceptedRequest = CreateFunctionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateFunctionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateFunctionResponse> transformer = CreateFunctionConverter.fromResponse();
        AsyncHandler<CreateFunctionRequest, CreateFunctionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateFunctionRequest, CreateFunctionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest request, AsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse> handler) {
        LOG.trace("Called async deleteApplication");
        DeleteApplicationRequest interceptedRequest = DeleteApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteApplicationResponse> transformer = DeleteApplicationConverter.fromResponse();
        AsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteApplicationRequest, DeleteApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest request, AsyncHandler<DeleteFunctionRequest, DeleteFunctionResponse> handler) {
        LOG.trace("Called async deleteFunction");
        DeleteFunctionRequest interceptedRequest = DeleteFunctionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFunctionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteFunctionResponse> transformer = DeleteFunctionConverter.fromResponse();
        AsyncHandler<DeleteFunctionRequest, DeleteFunctionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteFunctionRequest, DeleteFunctionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetApplicationResponse> getApplication(GetApplicationRequest request, AsyncHandler<GetApplicationRequest, GetApplicationResponse> handler) {
        LOG.trace("Called async getApplication");
        GetApplicationRequest interceptedRequest = GetApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApplicationResponse> transformer = GetApplicationConverter.fromResponse();
        AsyncHandler<GetApplicationRequest, GetApplicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetApplicationRequest, GetApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetFunctionResponse> getFunction(GetFunctionRequest request, AsyncHandler<GetFunctionRequest, GetFunctionResponse> handler) {
        LOG.trace("Called async getFunction");
        GetFunctionRequest interceptedRequest = GetFunctionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFunctionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFunctionResponse> transformer = GetFunctionConverter.fromResponse();
        AsyncHandler<GetFunctionRequest, GetFunctionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetFunctionRequest, GetFunctionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListApplicationsResponse> listApplications(ListApplicationsRequest request, AsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handler) {
        LOG.trace("Called async listApplications");
        ListApplicationsRequest interceptedRequest = ListApplicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApplicationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApplicationsResponse> transformer = ListApplicationsConverter.fromResponse();
        AsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListApplicationsRequest, ListApplicationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListFunctionsResponse> listFunctions(ListFunctionsRequest request, AsyncHandler<ListFunctionsRequest, ListFunctionsResponse> handler) {
        LOG.trace("Called async listFunctions");
        ListFunctionsRequest interceptedRequest = ListFunctionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFunctionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListFunctionsResponse> transformer = ListFunctionsConverter.fromResponse();
        AsyncHandler<ListFunctionsRequest, ListFunctionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListFunctionsRequest, ListFunctionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest request, AsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse> handler) {
        LOG.trace("Called async updateApplication");
        UpdateApplicationRequest interceptedRequest = UpdateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateApplicationResponse> transformer = UpdateApplicationConverter.fromResponse();
        AsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateApplicationRequest, UpdateApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateFunctionResponse> updateFunction(UpdateFunctionRequest request, AsyncHandler<UpdateFunctionRequest, UpdateFunctionResponse> handler) {
        LOG.trace("Called async updateFunction");
        UpdateFunctionRequest interceptedRequest = UpdateFunctionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateFunctionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateFunctionResponse> transformer = UpdateFunctionConverter.fromResponse();
        AsyncHandler<UpdateFunctionRequest, UpdateFunctionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateFunctionRequest, UpdateFunctionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FunctionsManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public FunctionsManagementAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new FunctionsManagementAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

