/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteFunctionRequest
extends BmcRequest<Void> {
    private String functionId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"functionId", "ifMatch", "opcRequestId"})
    DeleteFunctionRequest(String functionId, String ifMatch, String opcRequestId) {
        this.functionId = functionId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteFunctionRequest, Void> {
        private String functionId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteFunctionRequest o) {
            this.functionId(o.getFunctionId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteFunctionRequest build() {
            DeleteFunctionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder functionId(String functionId) {
            this.functionId = functionId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteFunctionRequest buildWithoutInvocationCallback() {
            return new DeleteFunctionRequest(this.functionId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteFunctionRequest.Builder(functionId=" + this.functionId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

