/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class InvokeFunctionRequest
extends BmcRequest<InputStream> {
    private String functionId;
    private InputStream invokeFunctionBody;
    private FnIntent fnIntent;
    private FnInvokeType fnInvokeType;
    private String opcRequestId;

    @InternalSdk
    public InputStream getBody$() {
        return this.invokeFunctionBody;
    }

    @ConstructorProperties(value={"functionId", "invokeFunctionBody", "fnIntent", "fnInvokeType", "opcRequestId"})
    InvokeFunctionRequest(String functionId, InputStream invokeFunctionBody, FnIntent fnIntent, FnInvokeType fnInvokeType, String opcRequestId) {
        this.functionId = functionId;
        this.invokeFunctionBody = invokeFunctionBody;
        this.fnIntent = fnIntent;
        this.fnInvokeType = fnInvokeType;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public InputStream getInvokeFunctionBody() {
        return this.invokeFunctionBody;
    }

    public FnIntent getFnIntent() {
        return this.fnIntent;
    }

    public FnInvokeType getFnInvokeType() {
        return this.fnInvokeType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<InvokeFunctionRequest, InputStream> {
        private String functionId;
        private InputStream invokeFunctionBody;
        private FnIntent fnIntent;
        private FnInvokeType fnInvokeType;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(InvokeFunctionRequest o) {
            this.functionId(o.getFunctionId());
            this.invokeFunctionBody(o.getInvokeFunctionBody());
            this.fnIntent(o.getFnIntent());
            this.fnInvokeType(o.getFnInvokeType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public InvokeFunctionRequest build() {
            InvokeFunctionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.invokeFunctionBody(body);
            return this;
        }

        Builder() {
        }

        public Builder functionId(String functionId) {
            this.functionId = functionId;
            return this;
        }

        public Builder invokeFunctionBody(InputStream invokeFunctionBody) {
            this.invokeFunctionBody = invokeFunctionBody;
            return this;
        }

        public Builder fnIntent(FnIntent fnIntent) {
            this.fnIntent = fnIntent;
            return this;
        }

        public Builder fnInvokeType(FnInvokeType fnInvokeType) {
            this.fnInvokeType = fnInvokeType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public InvokeFunctionRequest buildWithoutInvocationCallback() {
            return new InvokeFunctionRequest(this.functionId, this.invokeFunctionBody, this.fnIntent, this.fnInvokeType, this.opcRequestId);
        }

        public String toString() {
            return "InvokeFunctionRequest.Builder(functionId=" + this.functionId + ", invokeFunctionBody=" + this.invokeFunctionBody + ", fnIntent=" + (Object)((Object)this.fnIntent) + ", fnInvokeType=" + (Object)((Object)this.fnInvokeType) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum FnInvokeType {
        Detached("detached"),
        Sync("sync");

        private final String value;
        private static Map<String, FnInvokeType> map;

        private FnInvokeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FnInvokeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid FnInvokeType: " + key);
        }

        static {
            map = new HashMap<String, FnInvokeType>();
            for (FnInvokeType v : FnInvokeType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum FnIntent {
        Httprequest("httprequest"),
        Cloudevent("cloudevent");

        private final String value;
        private static Map<String, FnIntent> map;

        private FnIntent(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FnIntent create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid FnIntent: " + key);
        }

        static {
            map = new HashMap<String, FnIntent>();
            for (FnIntent v : FnIntent.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

