/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.goldengate.GoldenGateAsync;
import com.oracle.bmc.goldengate.internal.http.ChangeDatabaseRegistrationCompartmentConverter;
import com.oracle.bmc.goldengate.internal.http.ChangeDeploymentBackupCompartmentConverter;
import com.oracle.bmc.goldengate.internal.http.ChangeDeploymentCompartmentConverter;
import com.oracle.bmc.goldengate.internal.http.CreateDatabaseRegistrationConverter;
import com.oracle.bmc.goldengate.internal.http.CreateDeploymentBackupConverter;
import com.oracle.bmc.goldengate.internal.http.CreateDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.DeleteDatabaseRegistrationConverter;
import com.oracle.bmc.goldengate.internal.http.DeleteDeploymentBackupConverter;
import com.oracle.bmc.goldengate.internal.http.DeleteDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.GetDatabaseRegistrationConverter;
import com.oracle.bmc.goldengate.internal.http.GetDeploymentBackupConverter;
import com.oracle.bmc.goldengate.internal.http.GetDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.goldengate.internal.http.ListDatabaseRegistrationsConverter;
import com.oracle.bmc.goldengate.internal.http.ListDeploymentBackupsConverter;
import com.oracle.bmc.goldengate.internal.http.ListDeploymentsConverter;
import com.oracle.bmc.goldengate.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.goldengate.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.goldengate.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.goldengate.internal.http.RestoreDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.StartDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.StopDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.UpdateDatabaseRegistrationConverter;
import com.oracle.bmc.goldengate.internal.http.UpdateDeploymentBackupConverter;
import com.oracle.bmc.goldengate.internal.http.UpdateDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.UpgradeDeploymentConverter;
import com.oracle.bmc.goldengate.requests.ChangeDatabaseRegistrationCompartmentRequest;
import com.oracle.bmc.goldengate.requests.ChangeDeploymentBackupCompartmentRequest;
import com.oracle.bmc.goldengate.requests.ChangeDeploymentCompartmentRequest;
import com.oracle.bmc.goldengate.requests.CreateDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.CreateDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.CreateDeploymentRequest;
import com.oracle.bmc.goldengate.requests.DeleteDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.DeleteDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.DeleteDeploymentRequest;
import com.oracle.bmc.goldengate.requests.GetDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentRequest;
import com.oracle.bmc.goldengate.requests.GetWorkRequestRequest;
import com.oracle.bmc.goldengate.requests.ListDatabaseRegistrationsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentBackupsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestsRequest;
import com.oracle.bmc.goldengate.requests.RestoreDeploymentRequest;
import com.oracle.bmc.goldengate.requests.StartDeploymentRequest;
import com.oracle.bmc.goldengate.requests.StopDeploymentRequest;
import com.oracle.bmc.goldengate.requests.UpdateDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.UpdateDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.UpdateDeploymentRequest;
import com.oracle.bmc.goldengate.requests.UpgradeDeploymentRequest;
import com.oracle.bmc.goldengate.responses.ChangeDatabaseRegistrationCompartmentResponse;
import com.oracle.bmc.goldengate.responses.ChangeDeploymentBackupCompartmentResponse;
import com.oracle.bmc.goldengate.responses.ChangeDeploymentCompartmentResponse;
import com.oracle.bmc.goldengate.responses.CreateDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.CreateDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.CreateDeploymentResponse;
import com.oracle.bmc.goldengate.responses.DeleteDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.DeleteDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.DeleteDeploymentResponse;
import com.oracle.bmc.goldengate.responses.GetDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentResponse;
import com.oracle.bmc.goldengate.responses.GetWorkRequestResponse;
import com.oracle.bmc.goldengate.responses.ListDatabaseRegistrationsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentBackupsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestsResponse;
import com.oracle.bmc.goldengate.responses.RestoreDeploymentResponse;
import com.oracle.bmc.goldengate.responses.StartDeploymentResponse;
import com.oracle.bmc.goldengate.responses.StopDeploymentResponse;
import com.oracle.bmc.goldengate.responses.UpdateDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.UpdateDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.UpdateDeploymentResponse;
import com.oracle.bmc.goldengate.responses.UpgradeDeploymentResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoldenGateAsyncClient
implements GoldenGateAsync {
    private static final Logger LOG = LoggerFactory.getLogger(GoldenGateAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("GOLDENGATE").serviceEndpointPrefix("").serviceEndpointTemplate("https://goldengate.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public GoldenGateAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public GoldenGateAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public GoldenGateAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public GoldenGateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public GoldenGateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public GoldenGateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public GoldenGateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public GoldenGateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeDatabaseRegistrationCompartmentResponse> changeDatabaseRegistrationCompartment(ChangeDatabaseRegistrationCompartmentRequest request, AsyncHandler<ChangeDatabaseRegistrationCompartmentRequest, ChangeDatabaseRegistrationCompartmentResponse> handler) {
        LOG.trace("Called async changeDatabaseRegistrationCompartment");
        ChangeDatabaseRegistrationCompartmentRequest interceptedRequest = ChangeDatabaseRegistrationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDatabaseRegistrationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDatabaseRegistrationCompartmentResponse> transformer = ChangeDatabaseRegistrationCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeDatabaseRegistrationCompartmentRequest, ChangeDatabaseRegistrationCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeDatabaseRegistrationCompartmentRequest, ChangeDatabaseRegistrationCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeDeploymentBackupCompartmentResponse> changeDeploymentBackupCompartment(ChangeDeploymentBackupCompartmentRequest request, AsyncHandler<ChangeDeploymentBackupCompartmentRequest, ChangeDeploymentBackupCompartmentResponse> handler) {
        LOG.trace("Called async changeDeploymentBackupCompartment");
        ChangeDeploymentBackupCompartmentRequest interceptedRequest = ChangeDeploymentBackupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDeploymentBackupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDeploymentBackupCompartmentResponse> transformer = ChangeDeploymentBackupCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeDeploymentBackupCompartmentRequest, ChangeDeploymentBackupCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeDeploymentBackupCompartmentRequest, ChangeDeploymentBackupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeDeploymentCompartmentResponse> changeDeploymentCompartment(ChangeDeploymentCompartmentRequest request, AsyncHandler<ChangeDeploymentCompartmentRequest, ChangeDeploymentCompartmentResponse> handler) {
        LOG.trace("Called async changeDeploymentCompartment");
        ChangeDeploymentCompartmentRequest interceptedRequest = ChangeDeploymentCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDeploymentCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDeploymentCompartmentResponse> transformer = ChangeDeploymentCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeDeploymentCompartmentRequest, ChangeDeploymentCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeDeploymentCompartmentRequest, ChangeDeploymentCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDatabaseRegistrationResponse> createDatabaseRegistration(CreateDatabaseRegistrationRequest request, AsyncHandler<CreateDatabaseRegistrationRequest, CreateDatabaseRegistrationResponse> handler) {
        LOG.trace("Called async createDatabaseRegistration");
        CreateDatabaseRegistrationRequest interceptedRequest = CreateDatabaseRegistrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDatabaseRegistrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDatabaseRegistrationResponse> transformer = CreateDatabaseRegistrationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDatabaseRegistrationRequest, CreateDatabaseRegistrationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDatabaseRegistrationRequest, CreateDatabaseRegistrationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest request, AsyncHandler<CreateDeploymentRequest, CreateDeploymentResponse> handler) {
        LOG.trace("Called async createDeployment");
        CreateDeploymentRequest interceptedRequest = CreateDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDeploymentResponse> transformer = CreateDeploymentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDeploymentRequest, CreateDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDeploymentRequest, CreateDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDeploymentBackupResponse> createDeploymentBackup(CreateDeploymentBackupRequest request, AsyncHandler<CreateDeploymentBackupRequest, CreateDeploymentBackupResponse> handler) {
        LOG.trace("Called async createDeploymentBackup");
        CreateDeploymentBackupRequest interceptedRequest = CreateDeploymentBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeploymentBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDeploymentBackupResponse> transformer = CreateDeploymentBackupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDeploymentBackupRequest, CreateDeploymentBackupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDeploymentBackupRequest, CreateDeploymentBackupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDatabaseRegistrationResponse> deleteDatabaseRegistration(DeleteDatabaseRegistrationRequest request, AsyncHandler<DeleteDatabaseRegistrationRequest, DeleteDatabaseRegistrationResponse> handler) {
        LOG.trace("Called async deleteDatabaseRegistration");
        DeleteDatabaseRegistrationRequest interceptedRequest = DeleteDatabaseRegistrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDatabaseRegistrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDatabaseRegistrationResponse> transformer = DeleteDatabaseRegistrationConverter.fromResponse();
        AsyncHandler<DeleteDatabaseRegistrationRequest, DeleteDatabaseRegistrationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDatabaseRegistrationRequest, DeleteDatabaseRegistrationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDeploymentResponse> deleteDeployment(DeleteDeploymentRequest request, AsyncHandler<DeleteDeploymentRequest, DeleteDeploymentResponse> handler) {
        LOG.trace("Called async deleteDeployment");
        DeleteDeploymentRequest interceptedRequest = DeleteDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDeploymentResponse> transformer = DeleteDeploymentConverter.fromResponse();
        AsyncHandler<DeleteDeploymentRequest, DeleteDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDeploymentRequest, DeleteDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDeploymentBackupResponse> deleteDeploymentBackup(DeleteDeploymentBackupRequest request, AsyncHandler<DeleteDeploymentBackupRequest, DeleteDeploymentBackupResponse> handler) {
        LOG.trace("Called async deleteDeploymentBackup");
        DeleteDeploymentBackupRequest interceptedRequest = DeleteDeploymentBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeploymentBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDeploymentBackupResponse> transformer = DeleteDeploymentBackupConverter.fromResponse();
        AsyncHandler<DeleteDeploymentBackupRequest, DeleteDeploymentBackupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDeploymentBackupRequest, DeleteDeploymentBackupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDatabaseRegistrationResponse> getDatabaseRegistration(GetDatabaseRegistrationRequest request, AsyncHandler<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse> handler) {
        LOG.trace("Called async getDatabaseRegistration");
        GetDatabaseRegistrationRequest interceptedRequest = GetDatabaseRegistrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDatabaseRegistrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDatabaseRegistrationResponse> transformer = GetDatabaseRegistrationConverter.fromResponse();
        AsyncHandler<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDeploymentResponse> getDeployment(GetDeploymentRequest request, AsyncHandler<GetDeploymentRequest, GetDeploymentResponse> handler) {
        LOG.trace("Called async getDeployment");
        GetDeploymentRequest interceptedRequest = GetDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDeploymentResponse> transformer = GetDeploymentConverter.fromResponse();
        AsyncHandler<GetDeploymentRequest, GetDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDeploymentRequest, GetDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDeploymentBackupResponse> getDeploymentBackup(GetDeploymentBackupRequest request, AsyncHandler<GetDeploymentBackupRequest, GetDeploymentBackupResponse> handler) {
        LOG.trace("Called async getDeploymentBackup");
        GetDeploymentBackupRequest interceptedRequest = GetDeploymentBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeploymentBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDeploymentBackupResponse> transformer = GetDeploymentBackupConverter.fromResponse();
        AsyncHandler<GetDeploymentBackupRequest, GetDeploymentBackupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDeploymentBackupRequest, GetDeploymentBackupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDatabaseRegistrationsResponse> listDatabaseRegistrations(ListDatabaseRegistrationsRequest request, AsyncHandler<ListDatabaseRegistrationsRequest, ListDatabaseRegistrationsResponse> handler) {
        LOG.trace("Called async listDatabaseRegistrations");
        ListDatabaseRegistrationsRequest interceptedRequest = ListDatabaseRegistrationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDatabaseRegistrationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDatabaseRegistrationsResponse> transformer = ListDatabaseRegistrationsConverter.fromResponse();
        AsyncHandler<ListDatabaseRegistrationsRequest, ListDatabaseRegistrationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDatabaseRegistrationsRequest, ListDatabaseRegistrationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDeploymentBackupsResponse> listDeploymentBackups(ListDeploymentBackupsRequest request, AsyncHandler<ListDeploymentBackupsRequest, ListDeploymentBackupsResponse> handler) {
        LOG.trace("Called async listDeploymentBackups");
        ListDeploymentBackupsRequest interceptedRequest = ListDeploymentBackupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeploymentBackupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDeploymentBackupsResponse> transformer = ListDeploymentBackupsConverter.fromResponse();
        AsyncHandler<ListDeploymentBackupsRequest, ListDeploymentBackupsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDeploymentBackupsRequest, ListDeploymentBackupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest request, AsyncHandler<ListDeploymentsRequest, ListDeploymentsResponse> handler) {
        LOG.trace("Called async listDeployments");
        ListDeploymentsRequest interceptedRequest = ListDeploymentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeploymentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDeploymentsResponse> transformer = ListDeploymentsConverter.fromResponse();
        AsyncHandler<ListDeploymentsRequest, ListDeploymentsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDeploymentsRequest, ListDeploymentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RestoreDeploymentResponse> restoreDeployment(RestoreDeploymentRequest request, AsyncHandler<RestoreDeploymentRequest, RestoreDeploymentResponse> handler) {
        LOG.trace("Called async restoreDeployment");
        RestoreDeploymentRequest interceptedRequest = RestoreDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreDeploymentResponse> transformer = RestoreDeploymentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RestoreDeploymentRequest, RestoreDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RestoreDeploymentRequest, RestoreDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StartDeploymentResponse> startDeployment(StartDeploymentRequest request, AsyncHandler<StartDeploymentRequest, StartDeploymentResponse> handler) {
        LOG.trace("Called async startDeployment");
        StartDeploymentRequest interceptedRequest = StartDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartDeploymentResponse> transformer = StartDeploymentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StartDeploymentRequest, StartDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StartDeploymentRequest, StartDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StopDeploymentResponse> stopDeployment(StopDeploymentRequest request, AsyncHandler<StopDeploymentRequest, StopDeploymentResponse> handler) {
        LOG.trace("Called async stopDeployment");
        StopDeploymentRequest interceptedRequest = StopDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopDeploymentResponse> transformer = StopDeploymentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StopDeploymentRequest, StopDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StopDeploymentRequest, StopDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDatabaseRegistrationResponse> updateDatabaseRegistration(UpdateDatabaseRegistrationRequest request, AsyncHandler<UpdateDatabaseRegistrationRequest, UpdateDatabaseRegistrationResponse> handler) {
        LOG.trace("Called async updateDatabaseRegistration");
        UpdateDatabaseRegistrationRequest interceptedRequest = UpdateDatabaseRegistrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDatabaseRegistrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDatabaseRegistrationResponse> transformer = UpdateDatabaseRegistrationConverter.fromResponse();
        AsyncHandler<UpdateDatabaseRegistrationRequest, UpdateDatabaseRegistrationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDatabaseRegistrationRequest, UpdateDatabaseRegistrationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDeploymentResponse> updateDeployment(UpdateDeploymentRequest request, AsyncHandler<UpdateDeploymentRequest, UpdateDeploymentResponse> handler) {
        LOG.trace("Called async updateDeployment");
        UpdateDeploymentRequest interceptedRequest = UpdateDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDeploymentResponse> transformer = UpdateDeploymentConverter.fromResponse();
        AsyncHandler<UpdateDeploymentRequest, UpdateDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDeploymentRequest, UpdateDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDeploymentBackupResponse> updateDeploymentBackup(UpdateDeploymentBackupRequest request, AsyncHandler<UpdateDeploymentBackupRequest, UpdateDeploymentBackupResponse> handler) {
        LOG.trace("Called async updateDeploymentBackup");
        UpdateDeploymentBackupRequest interceptedRequest = UpdateDeploymentBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeploymentBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDeploymentBackupResponse> transformer = UpdateDeploymentBackupConverter.fromResponse();
        AsyncHandler<UpdateDeploymentBackupRequest, UpdateDeploymentBackupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDeploymentBackupRequest, UpdateDeploymentBackupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpgradeDeploymentResponse> upgradeDeployment(UpgradeDeploymentRequest request, AsyncHandler<UpgradeDeploymentRequest, UpgradeDeploymentResponse> handler) {
        LOG.trace("Called async upgradeDeployment");
        UpgradeDeploymentRequest interceptedRequest = UpgradeDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpgradeDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpgradeDeploymentResponse> transformer = UpgradeDeploymentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpgradeDeploymentRequest, UpgradeDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpgradeDeploymentRequest, UpgradeDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GoldenGateAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public GoldenGateAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new GoldenGateAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

