/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.goldengate.GoldenGate;
import com.oracle.bmc.goldengate.GoldenGatePaginators;
import com.oracle.bmc.goldengate.GoldenGateWaiters;
import com.oracle.bmc.goldengate.internal.http.ChangeDatabaseRegistrationCompartmentConverter;
import com.oracle.bmc.goldengate.internal.http.ChangeDeploymentBackupCompartmentConverter;
import com.oracle.bmc.goldengate.internal.http.ChangeDeploymentCompartmentConverter;
import com.oracle.bmc.goldengate.internal.http.CreateDatabaseRegistrationConverter;
import com.oracle.bmc.goldengate.internal.http.CreateDeploymentBackupConverter;
import com.oracle.bmc.goldengate.internal.http.CreateDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.DeleteDatabaseRegistrationConverter;
import com.oracle.bmc.goldengate.internal.http.DeleteDeploymentBackupConverter;
import com.oracle.bmc.goldengate.internal.http.DeleteDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.GetDatabaseRegistrationConverter;
import com.oracle.bmc.goldengate.internal.http.GetDeploymentBackupConverter;
import com.oracle.bmc.goldengate.internal.http.GetDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.goldengate.internal.http.ListDatabaseRegistrationsConverter;
import com.oracle.bmc.goldengate.internal.http.ListDeploymentBackupsConverter;
import com.oracle.bmc.goldengate.internal.http.ListDeploymentsConverter;
import com.oracle.bmc.goldengate.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.goldengate.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.goldengate.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.goldengate.internal.http.RestoreDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.StartDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.StopDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.UpdateDatabaseRegistrationConverter;
import com.oracle.bmc.goldengate.internal.http.UpdateDeploymentBackupConverter;
import com.oracle.bmc.goldengate.internal.http.UpdateDeploymentConverter;
import com.oracle.bmc.goldengate.internal.http.UpgradeDeploymentConverter;
import com.oracle.bmc.goldengate.requests.ChangeDatabaseRegistrationCompartmentRequest;
import com.oracle.bmc.goldengate.requests.ChangeDeploymentBackupCompartmentRequest;
import com.oracle.bmc.goldengate.requests.ChangeDeploymentCompartmentRequest;
import com.oracle.bmc.goldengate.requests.CreateDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.CreateDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.CreateDeploymentRequest;
import com.oracle.bmc.goldengate.requests.DeleteDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.DeleteDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.DeleteDeploymentRequest;
import com.oracle.bmc.goldengate.requests.GetDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentRequest;
import com.oracle.bmc.goldengate.requests.GetWorkRequestRequest;
import com.oracle.bmc.goldengate.requests.ListDatabaseRegistrationsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentBackupsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestsRequest;
import com.oracle.bmc.goldengate.requests.RestoreDeploymentRequest;
import com.oracle.bmc.goldengate.requests.StartDeploymentRequest;
import com.oracle.bmc.goldengate.requests.StopDeploymentRequest;
import com.oracle.bmc.goldengate.requests.UpdateDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.UpdateDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.UpdateDeploymentRequest;
import com.oracle.bmc.goldengate.requests.UpgradeDeploymentRequest;
import com.oracle.bmc.goldengate.responses.ChangeDatabaseRegistrationCompartmentResponse;
import com.oracle.bmc.goldengate.responses.ChangeDeploymentBackupCompartmentResponse;
import com.oracle.bmc.goldengate.responses.ChangeDeploymentCompartmentResponse;
import com.oracle.bmc.goldengate.responses.CreateDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.CreateDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.CreateDeploymentResponse;
import com.oracle.bmc.goldengate.responses.DeleteDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.DeleteDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.DeleteDeploymentResponse;
import com.oracle.bmc.goldengate.responses.GetDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentResponse;
import com.oracle.bmc.goldengate.responses.GetWorkRequestResponse;
import com.oracle.bmc.goldengate.responses.ListDatabaseRegistrationsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentBackupsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestsResponse;
import com.oracle.bmc.goldengate.responses.RestoreDeploymentResponse;
import com.oracle.bmc.goldengate.responses.StartDeploymentResponse;
import com.oracle.bmc.goldengate.responses.StopDeploymentResponse;
import com.oracle.bmc.goldengate.responses.UpdateDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.UpdateDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.UpdateDeploymentResponse;
import com.oracle.bmc.goldengate.responses.UpgradeDeploymentResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoldenGateClient
implements GoldenGate {
    private static final Logger LOG = LoggerFactory.getLogger(GoldenGateClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("GOLDENGATE").serviceEndpointPrefix("").serviceEndpointTemplate("https://goldengate.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final GoldenGateWaiters waiters;
    private final GoldenGatePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public GoldenGateClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public GoldenGateClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public GoldenGateClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public GoldenGateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public GoldenGateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public GoldenGateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public GoldenGateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public GoldenGateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected GoldenGateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("GoldenGate-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new GoldenGateWaiters(executorService, this);
        this.paginators = new GoldenGatePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeDatabaseRegistrationCompartmentResponse changeDatabaseRegistrationCompartment(ChangeDatabaseRegistrationCompartmentRequest request) {
        LOG.trace("Called changeDatabaseRegistrationCompartment");
        ChangeDatabaseRegistrationCompartmentRequest interceptedRequest = ChangeDatabaseRegistrationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDatabaseRegistrationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDatabaseRegistrationCompartmentResponse> transformer = ChangeDatabaseRegistrationCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeDatabaseRegistrationCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeDatabaseRegistrationCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeDatabaseRegistrationCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeDatabaseRegistrationCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeDeploymentBackupCompartmentResponse changeDeploymentBackupCompartment(ChangeDeploymentBackupCompartmentRequest request) {
        LOG.trace("Called changeDeploymentBackupCompartment");
        ChangeDeploymentBackupCompartmentRequest interceptedRequest = ChangeDeploymentBackupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDeploymentBackupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDeploymentBackupCompartmentResponse> transformer = ChangeDeploymentBackupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeDeploymentBackupCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeDeploymentBackupCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeDeploymentBackupCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeDeploymentBackupCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeDeploymentCompartmentResponse changeDeploymentCompartment(ChangeDeploymentCompartmentRequest request) {
        LOG.trace("Called changeDeploymentCompartment");
        ChangeDeploymentCompartmentRequest interceptedRequest = ChangeDeploymentCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDeploymentCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDeploymentCompartmentResponse> transformer = ChangeDeploymentCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeDeploymentCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeDeploymentCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeDeploymentCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeDeploymentCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDatabaseRegistrationResponse createDatabaseRegistration(CreateDatabaseRegistrationRequest request) {
        LOG.trace("Called createDatabaseRegistration");
        CreateDatabaseRegistrationRequest interceptedRequest = CreateDatabaseRegistrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDatabaseRegistrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDatabaseRegistrationResponse> transformer = CreateDatabaseRegistrationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDatabaseRegistrationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDatabaseRegistrationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDatabaseRegistrationDetails(), (BmcRequest)retriedRequest);
                return (CreateDatabaseRegistrationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest request) {
        LOG.trace("Called createDeployment");
        CreateDeploymentRequest interceptedRequest = CreateDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDeploymentResponse> transformer = CreateDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDeploymentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDeploymentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDeploymentDetails(), (BmcRequest)retriedRequest);
                return (CreateDeploymentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDeploymentBackupResponse createDeploymentBackup(CreateDeploymentBackupRequest request) {
        LOG.trace("Called createDeploymentBackup");
        CreateDeploymentBackupRequest interceptedRequest = CreateDeploymentBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeploymentBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDeploymentBackupResponse> transformer = CreateDeploymentBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDeploymentBackupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDeploymentBackupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDeploymentBackupDetails(), (BmcRequest)retriedRequest);
                return (CreateDeploymentBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDatabaseRegistrationResponse deleteDatabaseRegistration(DeleteDatabaseRegistrationRequest request) {
        LOG.trace("Called deleteDatabaseRegistration");
        DeleteDatabaseRegistrationRequest interceptedRequest = DeleteDatabaseRegistrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDatabaseRegistrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDatabaseRegistrationResponse> transformer = DeleteDatabaseRegistrationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDatabaseRegistrationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDatabaseRegistrationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDatabaseRegistrationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDeploymentResponse deleteDeployment(DeleteDeploymentRequest request) {
        LOG.trace("Called deleteDeployment");
        DeleteDeploymentRequest interceptedRequest = DeleteDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDeploymentResponse> transformer = DeleteDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDeploymentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDeploymentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDeploymentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDeploymentBackupResponse deleteDeploymentBackup(DeleteDeploymentBackupRequest request) {
        LOG.trace("Called deleteDeploymentBackup");
        DeleteDeploymentBackupRequest interceptedRequest = DeleteDeploymentBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeploymentBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDeploymentBackupResponse> transformer = DeleteDeploymentBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDeploymentBackupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDeploymentBackupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDeploymentBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDatabaseRegistrationResponse getDatabaseRegistration(GetDatabaseRegistrationRequest request) {
        LOG.trace("Called getDatabaseRegistration");
        GetDatabaseRegistrationRequest interceptedRequest = GetDatabaseRegistrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDatabaseRegistrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDatabaseRegistrationResponse> transformer = GetDatabaseRegistrationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDatabaseRegistrationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDatabaseRegistrationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDatabaseRegistrationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDeploymentResponse getDeployment(GetDeploymentRequest request) {
        LOG.trace("Called getDeployment");
        GetDeploymentRequest interceptedRequest = GetDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDeploymentResponse> transformer = GetDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDeploymentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDeploymentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDeploymentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDeploymentBackupResponse getDeploymentBackup(GetDeploymentBackupRequest request) {
        LOG.trace("Called getDeploymentBackup");
        GetDeploymentBackupRequest interceptedRequest = GetDeploymentBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeploymentBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDeploymentBackupResponse> transformer = GetDeploymentBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDeploymentBackupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDeploymentBackupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDeploymentBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDatabaseRegistrationsResponse listDatabaseRegistrations(ListDatabaseRegistrationsRequest request) {
        LOG.trace("Called listDatabaseRegistrations");
        ListDatabaseRegistrationsRequest interceptedRequest = ListDatabaseRegistrationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDatabaseRegistrationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDatabaseRegistrationsResponse> transformer = ListDatabaseRegistrationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDatabaseRegistrationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDatabaseRegistrationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDatabaseRegistrationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDeploymentBackupsResponse listDeploymentBackups(ListDeploymentBackupsRequest request) {
        LOG.trace("Called listDeploymentBackups");
        ListDeploymentBackupsRequest interceptedRequest = ListDeploymentBackupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeploymentBackupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDeploymentBackupsResponse> transformer = ListDeploymentBackupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDeploymentBackupsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDeploymentBackupsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDeploymentBackupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDeploymentsResponse listDeployments(ListDeploymentsRequest request) {
        LOG.trace("Called listDeployments");
        ListDeploymentsRequest interceptedRequest = ListDeploymentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeploymentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDeploymentsResponse> transformer = ListDeploymentsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDeploymentsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDeploymentsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDeploymentsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RestoreDeploymentResponse restoreDeployment(RestoreDeploymentRequest request) {
        LOG.trace("Called restoreDeployment");
        RestoreDeploymentRequest interceptedRequest = RestoreDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreDeploymentResponse> transformer = RestoreDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RestoreDeploymentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RestoreDeploymentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRestoreDeploymentDetails(), (BmcRequest)retriedRequest);
                return (RestoreDeploymentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StartDeploymentResponse startDeployment(StartDeploymentRequest request) {
        LOG.trace("Called startDeployment");
        StartDeploymentRequest interceptedRequest = StartDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartDeploymentResponse> transformer = StartDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StartDeploymentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StartDeploymentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getStartDeploymentDetails(), (BmcRequest)retriedRequest);
                return (StartDeploymentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StopDeploymentResponse stopDeployment(StopDeploymentRequest request) {
        LOG.trace("Called stopDeployment");
        StopDeploymentRequest interceptedRequest = StopDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopDeploymentResponse> transformer = StopDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StopDeploymentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StopDeploymentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getStopDeploymentDetails(), (BmcRequest)retriedRequest);
                return (StopDeploymentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDatabaseRegistrationResponse updateDatabaseRegistration(UpdateDatabaseRegistrationRequest request) {
        LOG.trace("Called updateDatabaseRegistration");
        UpdateDatabaseRegistrationRequest interceptedRequest = UpdateDatabaseRegistrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDatabaseRegistrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDatabaseRegistrationResponse> transformer = UpdateDatabaseRegistrationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDatabaseRegistrationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDatabaseRegistrationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDatabaseRegistrationDetails(), (BmcRequest)retriedRequest);
                return (UpdateDatabaseRegistrationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDeploymentResponse updateDeployment(UpdateDeploymentRequest request) {
        LOG.trace("Called updateDeployment");
        UpdateDeploymentRequest interceptedRequest = UpdateDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDeploymentResponse> transformer = UpdateDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDeploymentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDeploymentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDeploymentDetails(), (BmcRequest)retriedRequest);
                return (UpdateDeploymentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDeploymentBackupResponse updateDeploymentBackup(UpdateDeploymentBackupRequest request) {
        LOG.trace("Called updateDeploymentBackup");
        UpdateDeploymentBackupRequest interceptedRequest = UpdateDeploymentBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeploymentBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDeploymentBackupResponse> transformer = UpdateDeploymentBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDeploymentBackupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDeploymentBackupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDeploymentBackupDetails(), (BmcRequest)retriedRequest);
                return (UpdateDeploymentBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpgradeDeploymentResponse upgradeDeployment(UpgradeDeploymentRequest request) {
        LOG.trace("Called upgradeDeployment");
        UpgradeDeploymentRequest interceptedRequest = UpgradeDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpgradeDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpgradeDeploymentResponse> transformer = UpgradeDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpgradeDeploymentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpgradeDeploymentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpgradeDeploymentDetails(), (BmcRequest)retriedRequest);
                return (UpgradeDeploymentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GoldenGateWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public GoldenGatePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GoldenGateClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public GoldenGateClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new GoldenGateClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

