/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDeploymentBackupRequest
extends BmcRequest<Void> {
    private String deploymentBackupId;
    private String opcRequestId;

    @ConstructorProperties(value={"deploymentBackupId", "opcRequestId"})
    GetDeploymentBackupRequest(String deploymentBackupId, String opcRequestId) {
        this.deploymentBackupId = deploymentBackupId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDeploymentBackupId() {
        return this.deploymentBackupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDeploymentBackupRequest, Void> {
        private String deploymentBackupId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDeploymentBackupRequest o) {
            this.deploymentBackupId(o.getDeploymentBackupId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDeploymentBackupRequest build() {
            GetDeploymentBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder deploymentBackupId(String deploymentBackupId) {
            this.deploymentBackupId = deploymentBackupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDeploymentBackupRequest buildWithoutInvocationCallback() {
            return new GetDeploymentBackupRequest(this.deploymentBackupId, this.opcRequestId);
        }

        public String toString() {
            return "GetDeploymentBackupRequest.Builder(deploymentBackupId=" + this.deploymentBackupId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

