/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.goldengate.model.StopDeploymentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class StopDeploymentRequest
extends BmcRequest<StopDeploymentDetails> {
    private String deploymentId;
    private StopDeploymentDetails stopDeploymentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public StopDeploymentDetails getBody$() {
        return this.stopDeploymentDetails;
    }

    @ConstructorProperties(value={"deploymentId", "stopDeploymentDetails", "ifMatch", "opcRequestId", "opcRetryToken"})
    StopDeploymentRequest(String deploymentId, StopDeploymentDetails stopDeploymentDetails, String ifMatch, String opcRequestId, String opcRetryToken) {
        this.deploymentId = deploymentId;
        this.stopDeploymentDetails = stopDeploymentDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public StopDeploymentDetails getStopDeploymentDetails() {
        return this.stopDeploymentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<StopDeploymentRequest, StopDeploymentDetails> {
        private String deploymentId;
        private StopDeploymentDetails stopDeploymentDetails;
        private String ifMatch;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(StopDeploymentRequest o) {
            this.deploymentId(o.getDeploymentId());
            this.stopDeploymentDetails(o.getStopDeploymentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public StopDeploymentRequest build() {
            StopDeploymentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(StopDeploymentDetails body) {
            this.stopDeploymentDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder stopDeploymentDetails(StopDeploymentDetails stopDeploymentDetails) {
            this.stopDeploymentDetails = stopDeploymentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public StopDeploymentRequest buildWithoutInvocationCallback() {
            return new StopDeploymentRequest(this.deploymentId, this.stopDeploymentDetails, this.ifMatch, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "StopDeploymentRequest.Builder(deploymentId=" + this.deploymentId + ", stopDeploymentDetails=" + this.stopDeploymentDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

