/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.healthchecks.HealthChecksAsync;
import com.oracle.bmc.healthchecks.internal.http.ChangeHttpMonitorCompartmentConverter;
import com.oracle.bmc.healthchecks.internal.http.ChangePingMonitorCompartmentConverter;
import com.oracle.bmc.healthchecks.internal.http.CreateHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.CreateOnDemandHttpProbeConverter;
import com.oracle.bmc.healthchecks.internal.http.CreateOnDemandPingProbeConverter;
import com.oracle.bmc.healthchecks.internal.http.CreatePingMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.DeleteHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.DeletePingMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.GetHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.GetPingMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.ListHealthChecksVantagePointsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListHttpMonitorsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListHttpProbeResultsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListPingMonitorsConverter;
import com.oracle.bmc.healthchecks.internal.http.ListPingProbeResultsConverter;
import com.oracle.bmc.healthchecks.internal.http.UpdateHttpMonitorConverter;
import com.oracle.bmc.healthchecks.internal.http.UpdatePingMonitorConverter;
import com.oracle.bmc.healthchecks.requests.ChangeHttpMonitorCompartmentRequest;
import com.oracle.bmc.healthchecks.requests.ChangePingMonitorCompartmentRequest;
import com.oracle.bmc.healthchecks.requests.CreateHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.CreateOnDemandHttpProbeRequest;
import com.oracle.bmc.healthchecks.requests.CreateOnDemandPingProbeRequest;
import com.oracle.bmc.healthchecks.requests.CreatePingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.DeleteHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.DeletePingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.GetHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.GetPingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.ListHealthChecksVantagePointsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpProbeResultsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingProbeResultsRequest;
import com.oracle.bmc.healthchecks.requests.UpdateHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.UpdatePingMonitorRequest;
import com.oracle.bmc.healthchecks.responses.ChangeHttpMonitorCompartmentResponse;
import com.oracle.bmc.healthchecks.responses.ChangePingMonitorCompartmentResponse;
import com.oracle.bmc.healthchecks.responses.CreateHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.CreateOnDemandHttpProbeResponse;
import com.oracle.bmc.healthchecks.responses.CreateOnDemandPingProbeResponse;
import com.oracle.bmc.healthchecks.responses.CreatePingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.DeleteHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.DeletePingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.GetHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.GetPingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.ListHealthChecksVantagePointsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpProbeResultsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingProbeResultsResponse;
import com.oracle.bmc.healthchecks.responses.UpdateHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.UpdatePingMonitorResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthChecksAsyncClient
implements HealthChecksAsync {
    private static final Logger LOG = LoggerFactory.getLogger(HealthChecksAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("HEALTHCHECKS").serviceEndpointPrefix("healthchecks").serviceEndpointTemplate("https://healthchecks.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public HealthChecksAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public HealthChecksAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public HealthChecksAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public HealthChecksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public HealthChecksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public HealthChecksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public HealthChecksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public HealthChecksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeHttpMonitorCompartmentResponse> changeHttpMonitorCompartment(ChangeHttpMonitorCompartmentRequest request, AsyncHandler<ChangeHttpMonitorCompartmentRequest, ChangeHttpMonitorCompartmentResponse> handler) {
        LOG.trace("Called async changeHttpMonitorCompartment");
        ChangeHttpMonitorCompartmentRequest interceptedRequest = ChangeHttpMonitorCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeHttpMonitorCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeHttpMonitorCompartmentResponse> transformer = ChangeHttpMonitorCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeHttpMonitorCompartmentRequest, ChangeHttpMonitorCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeHttpMonitorCompartmentRequest, ChangeHttpMonitorCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangePingMonitorCompartmentResponse> changePingMonitorCompartment(ChangePingMonitorCompartmentRequest request, AsyncHandler<ChangePingMonitorCompartmentRequest, ChangePingMonitorCompartmentResponse> handler) {
        LOG.trace("Called async changePingMonitorCompartment");
        ChangePingMonitorCompartmentRequest interceptedRequest = ChangePingMonitorCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangePingMonitorCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangePingMonitorCompartmentResponse> transformer = ChangePingMonitorCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangePingMonitorCompartmentRequest, ChangePingMonitorCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangePingMonitorCompartmentRequest, ChangePingMonitorCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateHttpMonitorResponse> createHttpMonitor(CreateHttpMonitorRequest request, AsyncHandler<CreateHttpMonitorRequest, CreateHttpMonitorResponse> handler) {
        LOG.trace("Called async createHttpMonitor");
        CreateHttpMonitorRequest interceptedRequest = CreateHttpMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateHttpMonitorResponse> transformer = CreateHttpMonitorConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateHttpMonitorRequest, CreateHttpMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateHttpMonitorRequest, CreateHttpMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateOnDemandHttpProbeResponse> createOnDemandHttpProbe(CreateOnDemandHttpProbeRequest request, AsyncHandler<CreateOnDemandHttpProbeRequest, CreateOnDemandHttpProbeResponse> handler) {
        LOG.trace("Called async createOnDemandHttpProbe");
        CreateOnDemandHttpProbeRequest interceptedRequest = CreateOnDemandHttpProbeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOnDemandHttpProbeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateOnDemandHttpProbeResponse> transformer = CreateOnDemandHttpProbeConverter.fromResponse();
        AsyncHandler<CreateOnDemandHttpProbeRequest, CreateOnDemandHttpProbeResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateOnDemandHttpProbeRequest, CreateOnDemandHttpProbeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateOnDemandPingProbeResponse> createOnDemandPingProbe(CreateOnDemandPingProbeRequest request, AsyncHandler<CreateOnDemandPingProbeRequest, CreateOnDemandPingProbeResponse> handler) {
        LOG.trace("Called async createOnDemandPingProbe");
        CreateOnDemandPingProbeRequest interceptedRequest = CreateOnDemandPingProbeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOnDemandPingProbeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateOnDemandPingProbeResponse> transformer = CreateOnDemandPingProbeConverter.fromResponse();
        AsyncHandler<CreateOnDemandPingProbeRequest, CreateOnDemandPingProbeResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateOnDemandPingProbeRequest, CreateOnDemandPingProbeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePingMonitorResponse> createPingMonitor(CreatePingMonitorRequest request, AsyncHandler<CreatePingMonitorRequest, CreatePingMonitorResponse> handler) {
        LOG.trace("Called async createPingMonitor");
        CreatePingMonitorRequest interceptedRequest = CreatePingMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePingMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePingMonitorResponse> transformer = CreatePingMonitorConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreatePingMonitorRequest, CreatePingMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePingMonitorRequest, CreatePingMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteHttpMonitorResponse> deleteHttpMonitor(DeleteHttpMonitorRequest request, AsyncHandler<DeleteHttpMonitorRequest, DeleteHttpMonitorResponse> handler) {
        LOG.trace("Called async deleteHttpMonitor");
        DeleteHttpMonitorRequest interceptedRequest = DeleteHttpMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteHttpMonitorResponse> transformer = DeleteHttpMonitorConverter.fromResponse();
        AsyncHandler<DeleteHttpMonitorRequest, DeleteHttpMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteHttpMonitorRequest, DeleteHttpMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePingMonitorResponse> deletePingMonitor(DeletePingMonitorRequest request, AsyncHandler<DeletePingMonitorRequest, DeletePingMonitorResponse> handler) {
        LOG.trace("Called async deletePingMonitor");
        DeletePingMonitorRequest interceptedRequest = DeletePingMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePingMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePingMonitorResponse> transformer = DeletePingMonitorConverter.fromResponse();
        AsyncHandler<DeletePingMonitorRequest, DeletePingMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePingMonitorRequest, DeletePingMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetHttpMonitorResponse> getHttpMonitor(GetHttpMonitorRequest request, AsyncHandler<GetHttpMonitorRequest, GetHttpMonitorResponse> handler) {
        LOG.trace("Called async getHttpMonitor");
        GetHttpMonitorRequest interceptedRequest = GetHttpMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHttpMonitorResponse> transformer = GetHttpMonitorConverter.fromResponse();
        AsyncHandler<GetHttpMonitorRequest, GetHttpMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetHttpMonitorRequest, GetHttpMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPingMonitorResponse> getPingMonitor(GetPingMonitorRequest request, AsyncHandler<GetPingMonitorRequest, GetPingMonitorResponse> handler) {
        LOG.trace("Called async getPingMonitor");
        GetPingMonitorRequest interceptedRequest = GetPingMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPingMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPingMonitorResponse> transformer = GetPingMonitorConverter.fromResponse();
        AsyncHandler<GetPingMonitorRequest, GetPingMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPingMonitorRequest, GetPingMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListHealthChecksVantagePointsResponse> listHealthChecksVantagePoints(ListHealthChecksVantagePointsRequest request, AsyncHandler<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse> handler) {
        LOG.trace("Called async listHealthChecksVantagePoints");
        ListHealthChecksVantagePointsRequest interceptedRequest = ListHealthChecksVantagePointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListHealthChecksVantagePointsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListHealthChecksVantagePointsResponse> transformer = ListHealthChecksVantagePointsConverter.fromResponse();
        AsyncHandler<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListHttpMonitorsResponse> listHttpMonitors(ListHttpMonitorsRequest request, AsyncHandler<ListHttpMonitorsRequest, ListHttpMonitorsResponse> handler) {
        LOG.trace("Called async listHttpMonitors");
        ListHttpMonitorsRequest interceptedRequest = ListHttpMonitorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListHttpMonitorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListHttpMonitorsResponse> transformer = ListHttpMonitorsConverter.fromResponse();
        AsyncHandler<ListHttpMonitorsRequest, ListHttpMonitorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListHttpMonitorsRequest, ListHttpMonitorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListHttpProbeResultsResponse> listHttpProbeResults(ListHttpProbeResultsRequest request, AsyncHandler<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse> handler) {
        LOG.trace("Called async listHttpProbeResults");
        ListHttpProbeResultsRequest interceptedRequest = ListHttpProbeResultsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListHttpProbeResultsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListHttpProbeResultsResponse> transformer = ListHttpProbeResultsConverter.fromResponse();
        AsyncHandler<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPingMonitorsResponse> listPingMonitors(ListPingMonitorsRequest request, AsyncHandler<ListPingMonitorsRequest, ListPingMonitorsResponse> handler) {
        LOG.trace("Called async listPingMonitors");
        ListPingMonitorsRequest interceptedRequest = ListPingMonitorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPingMonitorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPingMonitorsResponse> transformer = ListPingMonitorsConverter.fromResponse();
        AsyncHandler<ListPingMonitorsRequest, ListPingMonitorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPingMonitorsRequest, ListPingMonitorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPingProbeResultsResponse> listPingProbeResults(ListPingProbeResultsRequest request, AsyncHandler<ListPingProbeResultsRequest, ListPingProbeResultsResponse> handler) {
        LOG.trace("Called async listPingProbeResults");
        ListPingProbeResultsRequest interceptedRequest = ListPingProbeResultsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPingProbeResultsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPingProbeResultsResponse> transformer = ListPingProbeResultsConverter.fromResponse();
        AsyncHandler<ListPingProbeResultsRequest, ListPingProbeResultsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPingProbeResultsRequest, ListPingProbeResultsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateHttpMonitorResponse> updateHttpMonitor(UpdateHttpMonitorRequest request, AsyncHandler<UpdateHttpMonitorRequest, UpdateHttpMonitorResponse> handler) {
        LOG.trace("Called async updateHttpMonitor");
        UpdateHttpMonitorRequest interceptedRequest = UpdateHttpMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHttpMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateHttpMonitorResponse> transformer = UpdateHttpMonitorConverter.fromResponse();
        AsyncHandler<UpdateHttpMonitorRequest, UpdateHttpMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateHttpMonitorRequest, UpdateHttpMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdatePingMonitorResponse> updatePingMonitor(UpdatePingMonitorRequest request, AsyncHandler<UpdatePingMonitorRequest, UpdatePingMonitorResponse> handler) {
        LOG.trace("Called async updatePingMonitor");
        UpdatePingMonitorRequest interceptedRequest = UpdatePingMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePingMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePingMonitorResponse> transformer = UpdatePingMonitorConverter.fromResponse();
        AsyncHandler<UpdatePingMonitorRequest, UpdatePingMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdatePingMonitorRequest, UpdatePingMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, HealthChecksAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public HealthChecksAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new HealthChecksAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

