/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.loadbalancer.LoadBalancer;
import com.oracle.bmc.loadbalancer.LoadBalancerPaginators;
import com.oracle.bmc.loadbalancer.LoadBalancerWaiters;
import com.oracle.bmc.loadbalancer.internal.http.ChangeLoadBalancerCompartmentConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateCertificateConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateListenerConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreatePathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateRoutingPolicyConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateRuleSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateSSLCipherSuiteConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteCertificateConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteListenerConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeletePathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteRoutingPolicyConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteRuleSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteSSLCipherSuiteConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendHealthConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendSetHealthConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetHealthCheckerConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetLoadBalancerHealthConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetPathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetRoutingPolicyConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetRuleSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetSSLCipherSuiteConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListBackendSetsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListBackendsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListCertificatesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListHostnamesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListListenerRulesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListLoadBalancerHealthsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListLoadBalancersConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListPathRouteSetsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListPoliciesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListProtocolsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListRoutingPoliciesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListRuleSetsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListSSLCipherSuitesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListShapesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateHealthCheckerConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateListenerConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateLoadBalancerShapeConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateNetworkSecurityGroupsConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdatePathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateRoutingPolicyConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateRuleSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateSSLCipherSuiteConverter;
import com.oracle.bmc.loadbalancer.requests.ChangeLoadBalancerCompartmentRequest;
import com.oracle.bmc.loadbalancer.requests.CreateBackendRequest;
import com.oracle.bmc.loadbalancer.requests.CreateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.CreateHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.CreateListenerRequest;
import com.oracle.bmc.loadbalancer.requests.CreateLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.CreatePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.CreateRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteBackendRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteListenerRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.DeletePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendSetHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetHealthCheckerRequest;
import com.oracle.bmc.loadbalancer.requests.GetHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.GetPathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.GetRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.GetWorkRequestRequest;
import com.oracle.bmc.loadbalancer.requests.ListBackendSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListBackendsRequest;
import com.oracle.bmc.loadbalancer.requests.ListCertificatesRequest;
import com.oracle.bmc.loadbalancer.requests.ListHostnamesRequest;
import com.oracle.bmc.loadbalancer.requests.ListListenerRulesRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancerHealthsRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancersRequest;
import com.oracle.bmc.loadbalancer.requests.ListPathRouteSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListProtocolsRequest;
import com.oracle.bmc.loadbalancer.requests.ListRoutingPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListRuleSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListSSLCipherSuitesRequest;
import com.oracle.bmc.loadbalancer.requests.ListShapesRequest;
import com.oracle.bmc.loadbalancer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateHealthCheckerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateListenerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateLoadBalancerShapeRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateNetworkSecurityGroupsRequest;
import com.oracle.bmc.loadbalancer.requests.UpdatePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.responses.ChangeLoadBalancerCompartmentResponse;
import com.oracle.bmc.loadbalancer.responses.CreateBackendResponse;
import com.oracle.bmc.loadbalancer.responses.CreateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.CreateHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.CreateListenerResponse;
import com.oracle.bmc.loadbalancer.responses.CreateLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.CreatePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.CreateRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteBackendResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteListenerResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.DeletePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendSetHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetHealthCheckerResponse;
import com.oracle.bmc.loadbalancer.responses.GetHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.GetLoadBalancerHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.GetPathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.GetRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.GetWorkRequestResponse;
import com.oracle.bmc.loadbalancer.responses.ListBackendSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListBackendsResponse;
import com.oracle.bmc.loadbalancer.responses.ListCertificatesResponse;
import com.oracle.bmc.loadbalancer.responses.ListHostnamesResponse;
import com.oracle.bmc.loadbalancer.responses.ListListenerRulesResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancerHealthsResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancersResponse;
import com.oracle.bmc.loadbalancer.responses.ListPathRouteSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListProtocolsResponse;
import com.oracle.bmc.loadbalancer.responses.ListRoutingPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListRuleSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListSSLCipherSuitesResponse;
import com.oracle.bmc.loadbalancer.responses.ListShapesResponse;
import com.oracle.bmc.loadbalancer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateBackendResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateHealthCheckerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateListenerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateLoadBalancerShapeResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateNetworkSecurityGroupsResponse;
import com.oracle.bmc.loadbalancer.responses.UpdatePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateSSLCipherSuiteResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerClient
implements LoadBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(LoadBalancerClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOADBALANCER").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final LoadBalancerWaiters waiters;
    private final LoadBalancerPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public LoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public LoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public LoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public LoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public LoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public LoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public LoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public LoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected LoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LoadBalancer-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new LoadBalancerWaiters(executorService, this);
        this.paginators = new LoadBalancerPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeLoadBalancerCompartmentResponse changeLoadBalancerCompartment(ChangeLoadBalancerCompartmentRequest request) {
        LOG.trace("Called changeLoadBalancerCompartment");
        ChangeLoadBalancerCompartmentRequest interceptedRequest = ChangeLoadBalancerCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLoadBalancerCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeLoadBalancerCompartmentResponse> transformer = ChangeLoadBalancerCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeLoadBalancerCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeLoadBalancerCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeLoadBalancerCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeLoadBalancerCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBackendResponse createBackend(CreateBackendRequest request) {
        LOG.trace("Called createBackend");
        CreateBackendRequest interceptedRequest = CreateBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBackendResponse> transformer = CreateBackendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateBackendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateBackendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateBackendDetails(), (BmcRequest)retriedRequest);
                return (CreateBackendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBackendSetResponse createBackendSet(CreateBackendSetRequest request) {
        LOG.trace("Called createBackendSet");
        CreateBackendSetRequest interceptedRequest = CreateBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBackendSetResponse> transformer = CreateBackendSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateBackendSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateBackendSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateBackendSetDetails(), (BmcRequest)retriedRequest);
                return (CreateBackendSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCertificateResponse createCertificate(CreateCertificateRequest request) {
        LOG.trace("Called createCertificate");
        CreateCertificateRequest interceptedRequest = CreateCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCertificateResponse> transformer = CreateCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateCertificateDetails(), (BmcRequest)retriedRequest);
                return (CreateCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateHostnameResponse createHostname(CreateHostnameRequest request) {
        LOG.trace("Called createHostname");
        CreateHostnameRequest interceptedRequest = CreateHostnameConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateHostnameConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateHostnameResponse> transformer = CreateHostnameConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateHostnameResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateHostnameResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateHostnameDetails(), (BmcRequest)retriedRequest);
                return (CreateHostnameResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateListenerResponse createListener(CreateListenerRequest request) {
        LOG.trace("Called createListener");
        CreateListenerRequest interceptedRequest = CreateListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateListenerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateListenerResponse> transformer = CreateListenerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateListenerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateListenerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateListenerDetails(), (BmcRequest)retriedRequest);
                return (CreateListenerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateLoadBalancerResponse createLoadBalancer(CreateLoadBalancerRequest request) {
        LOG.trace("Called createLoadBalancer");
        CreateLoadBalancerRequest interceptedRequest = CreateLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLoadBalancerResponse> transformer = CreateLoadBalancerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateLoadBalancerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateLoadBalancerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateLoadBalancerDetails(), (BmcRequest)retriedRequest);
                return (CreateLoadBalancerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePathRouteSetResponse createPathRouteSet(CreatePathRouteSetRequest request) {
        LOG.trace("Called createPathRouteSet");
        CreatePathRouteSetRequest interceptedRequest = CreatePathRouteSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePathRouteSetResponse> transformer = CreatePathRouteSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreatePathRouteSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreatePathRouteSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreatePathRouteSetDetails(), (BmcRequest)retriedRequest);
                return (CreatePathRouteSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateRoutingPolicyResponse createRoutingPolicy(CreateRoutingPolicyRequest request) {
        LOG.trace("Called createRoutingPolicy");
        CreateRoutingPolicyRequest interceptedRequest = CreateRoutingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRoutingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRoutingPolicyResponse> transformer = CreateRoutingPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateRoutingPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateRoutingPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateRoutingPolicyDetails(), (BmcRequest)retriedRequest);
                return (CreateRoutingPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateRuleSetResponse createRuleSet(CreateRuleSetRequest request) {
        LOG.trace("Called createRuleSet");
        CreateRuleSetRequest interceptedRequest = CreateRuleSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRuleSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRuleSetResponse> transformer = CreateRuleSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateRuleSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateRuleSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateRuleSetDetails(), (BmcRequest)retriedRequest);
                return (CreateRuleSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSSLCipherSuiteResponse createSSLCipherSuite(CreateSSLCipherSuiteRequest request) {
        LOG.trace("Called createSSLCipherSuite");
        CreateSSLCipherSuiteRequest interceptedRequest = CreateSSLCipherSuiteConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSSLCipherSuiteConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSSLCipherSuiteResponse> transformer = CreateSSLCipherSuiteConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateSSLCipherSuiteResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateSSLCipherSuiteResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateSSLCipherSuiteDetails(), (BmcRequest)retriedRequest);
                return (CreateSSLCipherSuiteResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBackendResponse deleteBackend(DeleteBackendRequest request) {
        LOG.trace("Called deleteBackend");
        DeleteBackendRequest interceptedRequest = DeleteBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBackendResponse> transformer = DeleteBackendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteBackendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteBackendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteBackendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBackendSetResponse deleteBackendSet(DeleteBackendSetRequest request) {
        LOG.trace("Called deleteBackendSet");
        DeleteBackendSetRequest interceptedRequest = DeleteBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBackendSetResponse> transformer = DeleteBackendSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteBackendSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteBackendSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteBackendSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest request) {
        LOG.trace("Called deleteCertificate");
        DeleteCertificateRequest interceptedRequest = DeleteCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCertificateResponse> transformer = DeleteCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteHostnameResponse deleteHostname(DeleteHostnameRequest request) {
        LOG.trace("Called deleteHostname");
        DeleteHostnameRequest interceptedRequest = DeleteHostnameConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteHostnameConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteHostnameResponse> transformer = DeleteHostnameConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteHostnameResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteHostnameResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteHostnameResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteListenerResponse deleteListener(DeleteListenerRequest request) {
        LOG.trace("Called deleteListener");
        DeleteListenerRequest interceptedRequest = DeleteListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteListenerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteListenerResponse> transformer = DeleteListenerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteListenerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteListenerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteListenerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteLoadBalancerResponse deleteLoadBalancer(DeleteLoadBalancerRequest request) {
        LOG.trace("Called deleteLoadBalancer");
        DeleteLoadBalancerRequest interceptedRequest = DeleteLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLoadBalancerResponse> transformer = DeleteLoadBalancerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteLoadBalancerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteLoadBalancerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteLoadBalancerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePathRouteSetResponse deletePathRouteSet(DeletePathRouteSetRequest request) {
        LOG.trace("Called deletePathRouteSet");
        DeletePathRouteSetRequest interceptedRequest = DeletePathRouteSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePathRouteSetResponse> transformer = DeletePathRouteSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeletePathRouteSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeletePathRouteSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeletePathRouteSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteRoutingPolicyResponse deleteRoutingPolicy(DeleteRoutingPolicyRequest request) {
        LOG.trace("Called deleteRoutingPolicy");
        DeleteRoutingPolicyRequest interceptedRequest = DeleteRoutingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRoutingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRoutingPolicyResponse> transformer = DeleteRoutingPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteRoutingPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteRoutingPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteRoutingPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteRuleSetResponse deleteRuleSet(DeleteRuleSetRequest request) {
        LOG.trace("Called deleteRuleSet");
        DeleteRuleSetRequest interceptedRequest = DeleteRuleSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRuleSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRuleSetResponse> transformer = DeleteRuleSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteRuleSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteRuleSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteRuleSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSSLCipherSuiteResponse deleteSSLCipherSuite(DeleteSSLCipherSuiteRequest request) {
        LOG.trace("Called deleteSSLCipherSuite");
        DeleteSSLCipherSuiteRequest interceptedRequest = DeleteSSLCipherSuiteConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSSLCipherSuiteConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSSLCipherSuiteResponse> transformer = DeleteSSLCipherSuiteConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteSSLCipherSuiteResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSSLCipherSuiteResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSSLCipherSuiteResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBackendResponse getBackend(GetBackendRequest request) {
        LOG.trace("Called getBackend");
        GetBackendRequest interceptedRequest = GetBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendResponse> transformer = GetBackendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetBackendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBackendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBackendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBackendHealthResponse getBackendHealth(GetBackendHealthRequest request) {
        LOG.trace("Called getBackendHealth");
        GetBackendHealthRequest interceptedRequest = GetBackendHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendHealthConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendHealthResponse> transformer = GetBackendHealthConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetBackendHealthResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBackendHealthResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBackendHealthResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBackendSetResponse getBackendSet(GetBackendSetRequest request) {
        LOG.trace("Called getBackendSet");
        GetBackendSetRequest interceptedRequest = GetBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendSetResponse> transformer = GetBackendSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetBackendSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBackendSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBackendSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBackendSetHealthResponse getBackendSetHealth(GetBackendSetHealthRequest request) {
        LOG.trace("Called getBackendSetHealth");
        GetBackendSetHealthRequest interceptedRequest = GetBackendSetHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendSetHealthConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendSetHealthResponse> transformer = GetBackendSetHealthConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetBackendSetHealthResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBackendSetHealthResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBackendSetHealthResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetHealthCheckerResponse getHealthChecker(GetHealthCheckerRequest request) {
        LOG.trace("Called getHealthChecker");
        GetHealthCheckerRequest interceptedRequest = GetHealthCheckerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHealthCheckerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHealthCheckerResponse> transformer = GetHealthCheckerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetHealthCheckerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetHealthCheckerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetHealthCheckerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetHostnameResponse getHostname(GetHostnameRequest request) {
        LOG.trace("Called getHostname");
        GetHostnameRequest interceptedRequest = GetHostnameConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHostnameConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHostnameResponse> transformer = GetHostnameConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetHostnameResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetHostnameResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetHostnameResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLoadBalancerResponse getLoadBalancer(GetLoadBalancerRequest request) {
        LOG.trace("Called getLoadBalancer");
        GetLoadBalancerRequest interceptedRequest = GetLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLoadBalancerResponse> transformer = GetLoadBalancerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLoadBalancerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLoadBalancerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLoadBalancerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLoadBalancerHealthResponse getLoadBalancerHealth(GetLoadBalancerHealthRequest request) {
        LOG.trace("Called getLoadBalancerHealth");
        GetLoadBalancerHealthRequest interceptedRequest = GetLoadBalancerHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLoadBalancerHealthConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLoadBalancerHealthResponse> transformer = GetLoadBalancerHealthConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLoadBalancerHealthResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLoadBalancerHealthResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLoadBalancerHealthResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPathRouteSetResponse getPathRouteSet(GetPathRouteSetRequest request) {
        LOG.trace("Called getPathRouteSet");
        GetPathRouteSetRequest interceptedRequest = GetPathRouteSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPathRouteSetResponse> transformer = GetPathRouteSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPathRouteSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPathRouteSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPathRouteSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRoutingPolicyResponse getRoutingPolicy(GetRoutingPolicyRequest request) {
        LOG.trace("Called getRoutingPolicy");
        GetRoutingPolicyRequest interceptedRequest = GetRoutingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoutingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoutingPolicyResponse> transformer = GetRoutingPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRoutingPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRoutingPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRoutingPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRuleSetResponse getRuleSet(GetRuleSetRequest request) {
        LOG.trace("Called getRuleSet");
        GetRuleSetRequest interceptedRequest = GetRuleSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRuleSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRuleSetResponse> transformer = GetRuleSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRuleSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRuleSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRuleSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSSLCipherSuiteResponse getSSLCipherSuite(GetSSLCipherSuiteRequest request) {
        LOG.trace("Called getSSLCipherSuite");
        GetSSLCipherSuiteRequest interceptedRequest = GetSSLCipherSuiteConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSSLCipherSuiteConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSSLCipherSuiteResponse> transformer = GetSSLCipherSuiteConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetSSLCipherSuiteResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSSLCipherSuiteResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSSLCipherSuiteResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBackendSetsResponse listBackendSets(ListBackendSetsRequest request) {
        LOG.trace("Called listBackendSets");
        ListBackendSetsRequest interceptedRequest = ListBackendSetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBackendSetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBackendSetsResponse> transformer = ListBackendSetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListBackendSetsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBackendSetsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBackendSetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBackendsResponse listBackends(ListBackendsRequest request) {
        LOG.trace("Called listBackends");
        ListBackendsRequest interceptedRequest = ListBackendsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBackendsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBackendsResponse> transformer = ListBackendsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListBackendsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBackendsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBackendsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCertificatesResponse listCertificates(ListCertificatesRequest request) {
        LOG.trace("Called listCertificates");
        ListCertificatesRequest interceptedRequest = ListCertificatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCertificatesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCertificatesResponse> transformer = ListCertificatesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCertificatesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCertificatesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCertificatesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListHostnamesResponse listHostnames(ListHostnamesRequest request) {
        LOG.trace("Called listHostnames");
        ListHostnamesRequest interceptedRequest = ListHostnamesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListHostnamesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListHostnamesResponse> transformer = ListHostnamesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListHostnamesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListHostnamesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListHostnamesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListListenerRulesResponse listListenerRules(ListListenerRulesRequest request) {
        LOG.trace("Called listListenerRules");
        ListListenerRulesRequest interceptedRequest = ListListenerRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListListenerRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListListenerRulesResponse> transformer = ListListenerRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListListenerRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListListenerRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListListenerRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLoadBalancerHealthsResponse listLoadBalancerHealths(ListLoadBalancerHealthsRequest request) {
        LOG.trace("Called listLoadBalancerHealths");
        ListLoadBalancerHealthsRequest interceptedRequest = ListLoadBalancerHealthsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLoadBalancerHealthsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLoadBalancerHealthsResponse> transformer = ListLoadBalancerHealthsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLoadBalancerHealthsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLoadBalancerHealthsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLoadBalancerHealthsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLoadBalancersResponse listLoadBalancers(ListLoadBalancersRequest request) {
        LOG.trace("Called listLoadBalancers");
        ListLoadBalancersRequest interceptedRequest = ListLoadBalancersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLoadBalancersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLoadBalancersResponse> transformer = ListLoadBalancersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLoadBalancersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLoadBalancersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLoadBalancersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPathRouteSetsResponse listPathRouteSets(ListPathRouteSetsRequest request) {
        LOG.trace("Called listPathRouteSets");
        ListPathRouteSetsRequest interceptedRequest = ListPathRouteSetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPathRouteSetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPathRouteSetsResponse> transformer = ListPathRouteSetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPathRouteSetsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPathRouteSetsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPathRouteSetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPoliciesResponse listPolicies(ListPoliciesRequest request) {
        LOG.trace("Called listPolicies");
        ListPoliciesRequest interceptedRequest = ListPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPoliciesResponse> transformer = ListPoliciesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPoliciesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPoliciesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPoliciesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListProtocolsResponse listProtocols(ListProtocolsRequest request) {
        LOG.trace("Called listProtocols");
        ListProtocolsRequest interceptedRequest = ListProtocolsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProtocolsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListProtocolsResponse> transformer = ListProtocolsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListProtocolsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListProtocolsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListProtocolsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRoutingPoliciesResponse listRoutingPolicies(ListRoutingPoliciesRequest request) {
        LOG.trace("Called listRoutingPolicies");
        ListRoutingPoliciesRequest interceptedRequest = ListRoutingPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRoutingPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRoutingPoliciesResponse> transformer = ListRoutingPoliciesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRoutingPoliciesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRoutingPoliciesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRoutingPoliciesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRuleSetsResponse listRuleSets(ListRuleSetsRequest request) {
        LOG.trace("Called listRuleSets");
        ListRuleSetsRequest interceptedRequest = ListRuleSetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRuleSetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRuleSetsResponse> transformer = ListRuleSetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRuleSetsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRuleSetsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRuleSetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSSLCipherSuitesResponse listSSLCipherSuites(ListSSLCipherSuitesRequest request) {
        LOG.trace("Called listSSLCipherSuites");
        ListSSLCipherSuitesRequest interceptedRequest = ListSSLCipherSuitesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSSLCipherSuitesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSSLCipherSuitesResponse> transformer = ListSSLCipherSuitesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSSLCipherSuitesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSSLCipherSuitesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSSLCipherSuitesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListShapesResponse listShapes(ListShapesRequest request) {
        LOG.trace("Called listShapes");
        ListShapesRequest interceptedRequest = ListShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListShapesResponse> transformer = ListShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListShapesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListShapesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListShapesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBackendResponse updateBackend(UpdateBackendRequest request) {
        LOG.trace("Called updateBackend");
        UpdateBackendRequest interceptedRequest = UpdateBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBackendResponse> transformer = UpdateBackendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateBackendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBackendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateBackendDetails(), (BmcRequest)retriedRequest);
                return (UpdateBackendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBackendSetResponse updateBackendSet(UpdateBackendSetRequest request) {
        LOG.trace("Called updateBackendSet");
        UpdateBackendSetRequest interceptedRequest = UpdateBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBackendSetResponse> transformer = UpdateBackendSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateBackendSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBackendSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateBackendSetDetails(), (BmcRequest)retriedRequest);
                return (UpdateBackendSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateHealthCheckerResponse updateHealthChecker(UpdateHealthCheckerRequest request) {
        LOG.trace("Called updateHealthChecker");
        UpdateHealthCheckerRequest interceptedRequest = UpdateHealthCheckerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHealthCheckerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateHealthCheckerResponse> transformer = UpdateHealthCheckerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateHealthCheckerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateHealthCheckerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getHealthChecker(), (BmcRequest)retriedRequest);
                return (UpdateHealthCheckerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateHostnameResponse updateHostname(UpdateHostnameRequest request) {
        LOG.trace("Called updateHostname");
        UpdateHostnameRequest interceptedRequest = UpdateHostnameConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHostnameConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateHostnameResponse> transformer = UpdateHostnameConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateHostnameResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateHostnameResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateHostnameDetails(), (BmcRequest)retriedRequest);
                return (UpdateHostnameResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateListenerResponse updateListener(UpdateListenerRequest request) {
        LOG.trace("Called updateListener");
        UpdateListenerRequest interceptedRequest = UpdateListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateListenerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateListenerResponse> transformer = UpdateListenerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateListenerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateListenerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateListenerDetails(), (BmcRequest)retriedRequest);
                return (UpdateListenerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateLoadBalancerResponse updateLoadBalancer(UpdateLoadBalancerRequest request) {
        LOG.trace("Called updateLoadBalancer");
        UpdateLoadBalancerRequest interceptedRequest = UpdateLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLoadBalancerResponse> transformer = UpdateLoadBalancerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateLoadBalancerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateLoadBalancerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateLoadBalancerDetails(), (BmcRequest)retriedRequest);
                return (UpdateLoadBalancerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateLoadBalancerShapeResponse updateLoadBalancerShape(UpdateLoadBalancerShapeRequest request) {
        LOG.trace("Called updateLoadBalancerShape");
        UpdateLoadBalancerShapeRequest interceptedRequest = UpdateLoadBalancerShapeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLoadBalancerShapeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLoadBalancerShapeResponse> transformer = UpdateLoadBalancerShapeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateLoadBalancerShapeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateLoadBalancerShapeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateLoadBalancerShapeDetails(), (BmcRequest)retriedRequest);
                return (UpdateLoadBalancerShapeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateNetworkSecurityGroupsResponse updateNetworkSecurityGroups(UpdateNetworkSecurityGroupsRequest request) {
        LOG.trace("Called updateNetworkSecurityGroups");
        UpdateNetworkSecurityGroupsRequest interceptedRequest = UpdateNetworkSecurityGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNetworkSecurityGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNetworkSecurityGroupsResponse> transformer = UpdateNetworkSecurityGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateNetworkSecurityGroupsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateNetworkSecurityGroupsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateNetworkSecurityGroupsDetails(), (BmcRequest)retriedRequest);
                return (UpdateNetworkSecurityGroupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePathRouteSetResponse updatePathRouteSet(UpdatePathRouteSetRequest request) {
        LOG.trace("Called updatePathRouteSet");
        UpdatePathRouteSetRequest interceptedRequest = UpdatePathRouteSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePathRouteSetResponse> transformer = UpdatePathRouteSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdatePathRouteSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdatePathRouteSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdatePathRouteSetDetails(), (BmcRequest)retriedRequest);
                return (UpdatePathRouteSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRoutingPolicyResponse updateRoutingPolicy(UpdateRoutingPolicyRequest request) {
        LOG.trace("Called updateRoutingPolicy");
        UpdateRoutingPolicyRequest interceptedRequest = UpdateRoutingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRoutingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRoutingPolicyResponse> transformer = UpdateRoutingPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateRoutingPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateRoutingPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateRoutingPolicyDetails(), (BmcRequest)retriedRequest);
                return (UpdateRoutingPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRuleSetResponse updateRuleSet(UpdateRuleSetRequest request) {
        LOG.trace("Called updateRuleSet");
        UpdateRuleSetRequest interceptedRequest = UpdateRuleSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRuleSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRuleSetResponse> transformer = UpdateRuleSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateRuleSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateRuleSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateRuleSetDetails(), (BmcRequest)retriedRequest);
                return (UpdateRuleSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSSLCipherSuiteResponse updateSSLCipherSuite(UpdateSSLCipherSuiteRequest request) {
        LOG.trace("Called updateSSLCipherSuite");
        UpdateSSLCipherSuiteRequest interceptedRequest = UpdateSSLCipherSuiteConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSSLCipherSuiteConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSSLCipherSuiteResponse> transformer = UpdateSSLCipherSuiteConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateSSLCipherSuiteResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateSSLCipherSuiteResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateSSLCipherSuiteDetails(), (BmcRequest)retriedRequest);
                return (UpdateSSLCipherSuiteResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public LoadBalancerWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public LoadBalancerPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LoadBalancerClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public LoadBalancerClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new LoadBalancerClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

