/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loadbalancer.model.BackendSetHealth;
import com.oracle.bmc.loadbalancer.requests.GetBackendSetHealthRequest;
import com.oracle.bmc.loadbalancer.responses.GetBackendSetHealthResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBackendSetHealthConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetBackendSetHealthConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetBackendSetHealthRequest interceptRequest(GetBackendSetHealthRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetBackendSetHealthRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20170115").path("loadBalancers").path(HttpUtils.encodePathSegment((String)request.getLoadBalancerId())).path("backendSets").path(HttpUtils.encodePathSegment((String)request.getBackendSetName())).path("health");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetBackendSetHealthResponse> fromResponse() {
        Function<Response, GetBackendSetHealthResponse> transformer = new Function<Response, GetBackendSetHealthResponse>(){

            public GetBackendSetHealthResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.loadbalancer.responses.GetBackendSetHealthResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(BackendSetHealth.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetBackendSetHealthResponse.Builder builder = GetBackendSetHealthResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.backendSetHealth((BackendSetHealth)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetBackendSetHealthResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

