/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteBackendRequest
extends BmcRequest<Void> {
    private String loadBalancerId;
    private String backendSetName;
    private String backendName;
    private String opcRequestId;

    @ConstructorProperties(value={"loadBalancerId", "backendSetName", "backendName", "opcRequestId"})
    DeleteBackendRequest(String loadBalancerId, String backendSetName, String backendName, String opcRequestId) {
        this.loadBalancerId = loadBalancerId;
        this.backendSetName = backendSetName;
        this.backendName = backendName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getBackendSetName() {
        return this.backendSetName;
    }

    public String getBackendName() {
        return this.backendName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteBackendRequest, Void> {
        private String loadBalancerId;
        private String backendSetName;
        private String backendName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteBackendRequest o) {
            this.loadBalancerId(o.getLoadBalancerId());
            this.backendSetName(o.getBackendSetName());
            this.backendName(o.getBackendName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteBackendRequest build() {
            DeleteBackendRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder backendSetName(String backendSetName) {
            this.backendSetName = backendSetName;
            return this;
        }

        public Builder backendName(String backendName) {
            this.backendName = backendName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteBackendRequest buildWithoutInvocationCallback() {
            return new DeleteBackendRequest(this.loadBalancerId, this.backendSetName, this.backendName, this.opcRequestId);
        }

        public String toString() {
            return "DeleteBackendRequest.Builder(loadBalancerId=" + this.loadBalancerId + ", backendSetName=" + this.backendSetName + ", backendName=" + this.backendName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

