/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import javax.ws.rs.client.Invocation;

public class AppendLookupDataRequest
extends BmcRequest<InputStream> {
    private String namespaceName;
    private String lookupName;
    private InputStream appendLookupFileBody;
    private Boolean isForce;
    private String charEncoding;
    private String opcRetryToken;
    private String opcRequestId;
    private String ifMatch;

    @InternalSdk
    public InputStream getBody$() {
        return this.appendLookupFileBody;
    }

    @ConstructorProperties(value={"namespaceName", "lookupName", "appendLookupFileBody", "isForce", "charEncoding", "opcRetryToken", "opcRequestId", "ifMatch"})
    AppendLookupDataRequest(String namespaceName, String lookupName, InputStream appendLookupFileBody, Boolean isForce, String charEncoding, String opcRetryToken, String opcRequestId, String ifMatch) {
        this.namespaceName = namespaceName;
        this.lookupName = lookupName;
        this.appendLookupFileBody = appendLookupFileBody;
        this.isForce = isForce;
        this.charEncoding = charEncoding;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLookupName() {
        return this.lookupName;
    }

    public InputStream getAppendLookupFileBody() {
        return this.appendLookupFileBody;
    }

    public Boolean getIsForce() {
        return this.isForce;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<AppendLookupDataRequest, InputStream> {
        private String namespaceName;
        private String lookupName;
        private InputStream appendLookupFileBody;
        private Boolean isForce;
        private String charEncoding;
        private String opcRetryToken;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AppendLookupDataRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.lookupName(o.getLookupName());
            this.appendLookupFileBody(o.getAppendLookupFileBody());
            this.isForce(o.getIsForce());
            this.charEncoding(o.getCharEncoding());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AppendLookupDataRequest build() {
            AppendLookupDataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.appendLookupFileBody(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder lookupName(String lookupName) {
            this.lookupName = lookupName;
            return this;
        }

        public Builder appendLookupFileBody(InputStream appendLookupFileBody) {
            this.appendLookupFileBody = appendLookupFileBody;
            return this;
        }

        public Builder isForce(Boolean isForce) {
            this.isForce = isForce;
            return this;
        }

        public Builder charEncoding(String charEncoding) {
            this.charEncoding = charEncoding;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public AppendLookupDataRequest buildWithoutInvocationCallback() {
            return new AppendLookupDataRequest(this.namespaceName, this.lookupName, this.appendLookupFileBody, this.isForce, this.charEncoding, this.opcRetryToken, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "AppendLookupDataRequest.Builder(namespaceName=" + this.namespaceName + ", lookupName=" + this.lookupName + ", appendLookupFileBody=" + this.appendLookupFileBody + ", isForce=" + this.isForce + ", charEncoding=" + this.charEncoding + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

