/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.loganalytics.model.LabelNames;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class BatchGetBasicInfoRequest
extends BmcRequest<LabelNames> {
    private String namespaceName;
    private LabelNames basicDetails;
    private Boolean isIncludeDeleted;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private BasicLabelSortBy basicLabelSortBy;
    private String opcRequestId;

    @InternalSdk
    public LabelNames getBody$() {
        return this.basicDetails;
    }

    @ConstructorProperties(value={"namespaceName", "basicDetails", "isIncludeDeleted", "limit", "page", "sortOrder", "basicLabelSortBy", "opcRequestId"})
    BatchGetBasicInfoRequest(String namespaceName, LabelNames basicDetails, Boolean isIncludeDeleted, Integer limit, String page, SortOrder sortOrder, BasicLabelSortBy basicLabelSortBy, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.basicDetails = basicDetails;
        this.isIncludeDeleted = isIncludeDeleted;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.basicLabelSortBy = basicLabelSortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public LabelNames getBasicDetails() {
        return this.basicDetails;
    }

    public Boolean getIsIncludeDeleted() {
        return this.isIncludeDeleted;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public BasicLabelSortBy getBasicLabelSortBy() {
        return this.basicLabelSortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<BatchGetBasicInfoRequest, LabelNames> {
        private String namespaceName;
        private LabelNames basicDetails;
        private Boolean isIncludeDeleted;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private BasicLabelSortBy basicLabelSortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BatchGetBasicInfoRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.basicDetails(o.getBasicDetails());
            this.isIncludeDeleted(o.getIsIncludeDeleted());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.basicLabelSortBy(o.getBasicLabelSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BatchGetBasicInfoRequest build() {
            BatchGetBasicInfoRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(LabelNames body) {
            this.basicDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder basicDetails(LabelNames basicDetails) {
            this.basicDetails = basicDetails;
            return this;
        }

        public Builder isIncludeDeleted(Boolean isIncludeDeleted) {
            this.isIncludeDeleted = isIncludeDeleted;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder basicLabelSortBy(BasicLabelSortBy basicLabelSortBy) {
            this.basicLabelSortBy = basicLabelSortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public BatchGetBasicInfoRequest buildWithoutInvocationCallback() {
            return new BatchGetBasicInfoRequest(this.namespaceName, this.basicDetails, this.isIncludeDeleted, this.limit, this.page, this.sortOrder, this.basicLabelSortBy, this.opcRequestId);
        }

        public String toString() {
            return "BatchGetBasicInfoRequest.Builder(namespaceName=" + this.namespaceName + ", basicDetails=" + this.basicDetails + ", isIncludeDeleted=" + this.isIncludeDeleted + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", basicLabelSortBy=" + (Object)((Object)this.basicLabelSortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum BasicLabelSortBy {
        Name("name"),
        Priority("priority");

        private final String value;
        private static Map<String, BasicLabelSortBy> map;

        private BasicLabelSortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BasicLabelSortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid BasicLabelSortBy: " + key);
        }

        static {
            map = new HashMap<String, BasicLabelSortBy>();
            for (BasicLabelSortBy v : BasicLabelSortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

