/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.ws.rs.client.Invocation;

public class CleanRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String scheduledTaskId;
    private Date timeStart;
    private Date timeEnd;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"namespaceName", "scheduledTaskId", "timeStart", "timeEnd", "opcRequestId", "opcRetryToken"})
    CleanRequest(String namespaceName, String scheduledTaskId, Date timeStart, Date timeEnd, String opcRequestId, String opcRetryToken) {
        this.namespaceName = namespaceName;
        this.scheduledTaskId = scheduledTaskId;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getScheduledTaskId() {
        return this.scheduledTaskId;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CleanRequest, Void> {
        private String namespaceName;
        private String scheduledTaskId;
        private Date timeStart;
        private Date timeEnd;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CleanRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.scheduledTaskId(o.getScheduledTaskId());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CleanRequest build() {
            CleanRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder scheduledTaskId(String scheduledTaskId) {
            this.scheduledTaskId = scheduledTaskId;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CleanRequest buildWithoutInvocationCallback() {
            return new CleanRequest(this.namespaceName, this.scheduledTaskId, this.timeStart, this.timeEnd, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CleanRequest.Builder(namespaceName=" + this.namespaceName + ", scheduledTaskId=" + this.scheduledTaskId + ", timeStart=" + this.timeStart + ", timeEnd=" + this.timeEnd + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

