/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.loganalytics.model.FilterDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class FilterRequest
extends BmcRequest<FilterDetails> {
    private String namespaceName;
    private FilterDetails filterDetails;
    private String opcRequestId;

    @InternalSdk
    public FilterDetails getBody$() {
        return this.filterDetails;
    }

    @ConstructorProperties(value={"namespaceName", "filterDetails", "opcRequestId"})
    FilterRequest(String namespaceName, FilterDetails filterDetails, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.filterDetails = filterDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public FilterDetails getFilterDetails() {
        return this.filterDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<FilterRequest, FilterDetails> {
        private String namespaceName;
        private FilterDetails filterDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(FilterRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.filterDetails(o.getFilterDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public FilterRequest build() {
            FilterRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(FilterDetails body) {
            this.filterDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder filterDetails(FilterDetails filterDetails) {
            this.filterDetails = filterDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public FilterRequest buildWithoutInvocationCallback() {
            return new FilterRequest(this.namespaceName, this.filterDetails, this.opcRequestId);
        }

        public String toString() {
            return "FilterRequest.Builder(namespaceName=" + this.namespaceName + ", filterDetails=" + this.filterDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

