/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetColumnNamesRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String sqlQuery;
    private String opcRetryToken;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "sqlQuery", "opcRetryToken", "opcRequestId"})
    GetColumnNamesRequest(String namespaceName, String sqlQuery, String opcRetryToken, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.sqlQuery = sqlQuery;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetColumnNamesRequest, Void> {
        private String namespaceName;
        private String sqlQuery;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetColumnNamesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.sqlQuery(o.getSqlQuery());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetColumnNamesRequest build() {
            GetColumnNamesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder sqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetColumnNamesRequest buildWithoutInvocationCallback() {
            return new GetColumnNamesRequest(this.namespaceName, this.sqlQuery, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "GetColumnNamesRequest.Builder(namespaceName=" + this.namespaceName + ", sqlQuery=" + this.sqlQuery + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

