/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetLogAnalyticsEntityTypeRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String entityTypeName;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "entityTypeName", "opcRequestId"})
    GetLogAnalyticsEntityTypeRequest(String namespaceName, String entityTypeName, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.entityTypeName = entityTypeName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLogAnalyticsEntityTypeRequest, Void> {
        private String namespaceName;
        private String entityTypeName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLogAnalyticsEntityTypeRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.entityTypeName(o.getEntityTypeName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLogAnalyticsEntityTypeRequest build() {
            GetLogAnalyticsEntityTypeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder entityTypeName(String entityTypeName) {
            this.entityTypeName = entityTypeName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetLogAnalyticsEntityTypeRequest buildWithoutInvocationCallback() {
            return new GetLogAnalyticsEntityTypeRequest(this.namespaceName, this.entityTypeName, this.opcRequestId);
        }

        public String toString() {
            return "GetLogAnalyticsEntityTypeRequest.Builder(namespaceName=" + this.namespaceName + ", entityTypeName=" + this.entityTypeName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

