/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetParserRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String parserName;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "parserName", "opcRequestId"})
    GetParserRequest(String namespaceName, String parserName, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.parserName = parserName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getParserName() {
        return this.parserName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetParserRequest, Void> {
        private String namespaceName;
        private String parserName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetParserRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.parserName(o.getParserName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetParserRequest build() {
            GetParserRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder parserName(String parserName) {
            this.parserName = parserName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetParserRequest buildWithoutInvocationCallback() {
            return new GetParserRequest(this.namespaceName, this.parserName, this.opcRequestId);
        }

        public String toString() {
            return "GetParserRequest.Builder(namespaceName=" + this.namespaceName + ", parserName=" + this.parserName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

