/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class GetQueryResultRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String workRequestId;
    private String page;
    private Integer limit;
    private String opcRequestId;
    private Boolean shouldIncludeColumns;
    private Boolean shouldIncludeFields;
    private OutputMode outputMode;

    @ConstructorProperties(value={"namespaceName", "workRequestId", "page", "limit", "opcRequestId", "shouldIncludeColumns", "shouldIncludeFields", "outputMode"})
    GetQueryResultRequest(String namespaceName, String workRequestId, String page, Integer limit, String opcRequestId, Boolean shouldIncludeColumns, Boolean shouldIncludeFields, OutputMode outputMode) {
        this.namespaceName = namespaceName;
        this.workRequestId = workRequestId;
        this.page = page;
        this.limit = limit;
        this.opcRequestId = opcRequestId;
        this.shouldIncludeColumns = shouldIncludeColumns;
        this.shouldIncludeFields = shouldIncludeFields;
        this.outputMode = outputMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getShouldIncludeColumns() {
        return this.shouldIncludeColumns;
    }

    public Boolean getShouldIncludeFields() {
        return this.shouldIncludeFields;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    public static class Builder
    implements BmcRequest.Builder<GetQueryResultRequest, Void> {
        private String namespaceName;
        private String workRequestId;
        private String page;
        private Integer limit;
        private String opcRequestId;
        private Boolean shouldIncludeColumns;
        private Boolean shouldIncludeFields;
        private OutputMode outputMode;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetQueryResultRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.workRequestId(o.getWorkRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.shouldIncludeColumns(o.getShouldIncludeColumns());
            this.shouldIncludeFields(o.getShouldIncludeFields());
            this.outputMode(o.getOutputMode());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetQueryResultRequest build() {
            GetQueryResultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder shouldIncludeColumns(Boolean shouldIncludeColumns) {
            this.shouldIncludeColumns = shouldIncludeColumns;
            return this;
        }

        public Builder shouldIncludeFields(Boolean shouldIncludeFields) {
            this.shouldIncludeFields = shouldIncludeFields;
            return this;
        }

        public Builder outputMode(OutputMode outputMode) {
            this.outputMode = outputMode;
            return this;
        }

        public GetQueryResultRequest buildWithoutInvocationCallback() {
            return new GetQueryResultRequest(this.namespaceName, this.workRequestId, this.page, this.limit, this.opcRequestId, this.shouldIncludeColumns, this.shouldIncludeFields, this.outputMode);
        }

        public String toString() {
            return "GetQueryResultRequest.Builder(namespaceName=" + this.namespaceName + ", workRequestId=" + this.workRequestId + ", page=" + this.page + ", limit=" + this.limit + ", opcRequestId=" + this.opcRequestId + ", shouldIncludeColumns=" + this.shouldIncludeColumns + ", shouldIncludeFields=" + this.shouldIncludeFields + ", outputMode=" + (Object)((Object)this.outputMode) + ")";
        }
    }

    public static enum OutputMode {
        JsonRows("JSON_ROWS");

        private final String value;
        private static Map<String, OutputMode> map;

        private OutputMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OutputMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid OutputMode: " + key);
        }

        static {
            map = new HashMap<String, OutputMode>();
            for (OutputMode v : OutputMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

