/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetUploadRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String uploadReference;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "uploadReference", "opcRequestId"})
    GetUploadRequest(String namespaceName, String uploadReference, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.uploadReference = uploadReference;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUploadReference() {
        return this.uploadReference;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetUploadRequest, Void> {
        private String namespaceName;
        private String uploadReference;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetUploadRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.uploadReference(o.getUploadReference());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetUploadRequest build() {
            GetUploadRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder uploadReference(String uploadReference) {
            this.uploadReference = uploadReference;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetUploadRequest buildWithoutInvocationCallback() {
            return new GetUploadRequest(this.namespaceName, this.uploadReference, this.opcRequestId);
        }

        public String toString() {
            return "GetUploadRequest.Builder(namespaceName=" + this.namespaceName + ", uploadReference=" + this.uploadReference + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

