/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.loganalytics.model.StorageOperationType;
import com.oracle.bmc.loganalytics.model.WorkRequestStatus;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListStorageWorkRequestsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String namespaceName;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private StorageOperationType operationType;
    private WorkRequestStatus status;
    private Date timeStarted;
    private Date timeFinished;
    private String policyName;
    private String policyId;

    @ConstructorProperties(value={"compartmentId", "namespaceName", "opcRequestId", "limit", "page", "sortOrder", "sortBy", "operationType", "status", "timeStarted", "timeFinished", "policyName", "policyId"})
    ListStorageWorkRequestsRequest(String compartmentId, String namespaceName, String opcRequestId, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, StorageOperationType operationType, WorkRequestStatus status, Date timeStarted, Date timeFinished, String policyName, String policyId) {
        this.compartmentId = compartmentId;
        this.namespaceName = namespaceName;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.operationType = operationType;
        this.status = status;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.policyName = policyName;
        this.policyId = policyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public StorageOperationType getOperationType() {
        return this.operationType;
    }

    public WorkRequestStatus getStatus() {
        return this.status;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListStorageWorkRequestsRequest, Void> {
        private String compartmentId;
        private String namespaceName;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private StorageOperationType operationType;
        private WorkRequestStatus status;
        private Date timeStarted;
        private Date timeFinished;
        private String policyName;
        private String policyId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListStorageWorkRequestsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.namespaceName(o.getNamespaceName());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.operationType(o.getOperationType());
            this.status(o.getStatus());
            this.timeStarted(o.getTimeStarted());
            this.timeFinished(o.getTimeFinished());
            this.policyName(o.getPolicyName());
            this.policyId(o.getPolicyId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListStorageWorkRequestsRequest build() {
            ListStorageWorkRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder operationType(StorageOperationType operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder status(WorkRequestStatus status) {
            this.status = status;
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            return this;
        }

        public Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public ListStorageWorkRequestsRequest buildWithoutInvocationCallback() {
            return new ListStorageWorkRequestsRequest(this.compartmentId, this.namespaceName, this.opcRequestId, this.limit, this.page, this.sortOrder, this.sortBy, this.operationType, this.status, this.timeStarted, this.timeFinished, this.policyName, this.policyId);
        }

        public String toString() {
            return "ListStorageWorkRequestsRequest.Builder(compartmentId=" + this.compartmentId + ", namespaceName=" + this.namespaceName + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", operationType=" + (Object)((Object)this.operationType) + ", status=" + (Object)((Object)this.status) + ", timeStarted=" + this.timeStarted + ", timeFinished=" + this.timeFinished + ", policyName=" + this.policyName + ", policyId=" + this.policyId + ")";
        }
    }

    public static enum SortBy {
        TimeAccepted("timeAccepted"),
        TimeExpires("timeExpires"),
        TimeFinished("timeFinished");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

