/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class PauseScheduledTaskRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String scheduledTaskId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "scheduledTaskId", "ifMatch", "opcRequestId"})
    PauseScheduledTaskRequest(String namespaceName, String scheduledTaskId, String ifMatch, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.scheduledTaskId = scheduledTaskId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getScheduledTaskId() {
        return this.scheduledTaskId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<PauseScheduledTaskRequest, Void> {
        private String namespaceName;
        private String scheduledTaskId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PauseScheduledTaskRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.scheduledTaskId(o.getScheduledTaskId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PauseScheduledTaskRequest build() {
            PauseScheduledTaskRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder scheduledTaskId(String scheduledTaskId) {
            this.scheduledTaskId = scheduledTaskId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public PauseScheduledTaskRequest buildWithoutInvocationCallback() {
            return new PauseScheduledTaskRequest(this.namespaceName, this.scheduledTaskId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "PauseScheduledTaskRequest.Builder(namespaceName=" + this.namespaceName + ", scheduledTaskId=" + this.scheduledTaskId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

