/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ValidateSourceMappingRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String objectLocation;
    private String filename;
    private String logSourceName;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "objectLocation", "filename", "logSourceName", "opcRequestId"})
    ValidateSourceMappingRequest(String namespaceName, String objectLocation, String filename, String logSourceName, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.objectLocation = objectLocation;
        this.filename = filename;
        this.logSourceName = logSourceName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getObjectLocation() {
        return this.objectLocation;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getLogSourceName() {
        return this.logSourceName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidateSourceMappingRequest, Void> {
        private String namespaceName;
        private String objectLocation;
        private String filename;
        private String logSourceName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidateSourceMappingRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.objectLocation(o.getObjectLocation());
            this.filename(o.getFilename());
            this.logSourceName(o.getLogSourceName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidateSourceMappingRequest build() {
            ValidateSourceMappingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder objectLocation(String objectLocation) {
            this.objectLocation = objectLocation;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder logSourceName(String logSourceName) {
            this.logSourceName = logSourceName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ValidateSourceMappingRequest buildWithoutInvocationCallback() {
            return new ValidateSourceMappingRequest(this.namespaceName, this.objectLocation, this.filename, this.logSourceName, this.opcRequestId);
        }

        public String toString() {
            return "ValidateSourceMappingRequest.Builder(namespaceName=" + this.namespaceName + ", objectLocation=" + this.objectLocation + ", filename=" + this.filename + ", logSourceName=" + this.logSourceName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

