/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.logging.model.UnifiedAgentConfigurationCollection;
import com.oracle.bmc.logging.requests.ListUnifiedAgentConfigurationsRequest;
import com.oracle.bmc.logging.responses.ListUnifiedAgentConfigurationsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUnifiedAgentConfigurationsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListUnifiedAgentConfigurationsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListUnifiedAgentConfigurationsRequest interceptRequest(ListUnifiedAgentConfigurationsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListUnifiedAgentConfigurationsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200531").path("unifiedAgentConfigurations");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getLogId() != null) {
            target = target.queryParam("logId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLogId())});
        }
        if (request.getIsCompartmentIdInSubtree() != null) {
            target = target.queryParam("isCompartmentIdInSubtree", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsCompartmentIdInSubtree())});
        }
        if (request.getGroupId() != null) {
            target = target.queryParam("groupId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getGroupId())});
        }
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListUnifiedAgentConfigurationsResponse> fromResponse() {
        Function<Response, ListUnifiedAgentConfigurationsResponse> transformer = new Function<Response, ListUnifiedAgentConfigurationsResponse>(){

            public ListUnifiedAgentConfigurationsResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcPreviousPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.logging.responses.ListUnifiedAgentConfigurationsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(UnifiedAgentConfigurationCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListUnifiedAgentConfigurationsResponse.Builder builder = ListUnifiedAgentConfigurationsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.unifiedAgentConfigurationCollection((UnifiedAgentConfigurationCollection)response.getItem());
                Optional opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcPreviousPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-previous-page")).isPresent()) {
                    builder.opcPreviousPage((String)HeaderUtils.toValue((String)"opc-previous-page", (String)((String)((List)opcPreviousPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListUnifiedAgentConfigurationsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

