/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.marketplace.MarketplaceAsync;
import com.oracle.bmc.marketplace.internal.http.ChangePublicationCompartmentConverter;
import com.oracle.bmc.marketplace.internal.http.CreateAcceptedAgreementConverter;
import com.oracle.bmc.marketplace.internal.http.CreatePublicationConverter;
import com.oracle.bmc.marketplace.internal.http.DeleteAcceptedAgreementConverter;
import com.oracle.bmc.marketplace.internal.http.DeletePublicationConverter;
import com.oracle.bmc.marketplace.internal.http.GetAcceptedAgreementConverter;
import com.oracle.bmc.marketplace.internal.http.GetAgreementConverter;
import com.oracle.bmc.marketplace.internal.http.GetListingConverter;
import com.oracle.bmc.marketplace.internal.http.GetPackageConverter;
import com.oracle.bmc.marketplace.internal.http.GetPublicationConverter;
import com.oracle.bmc.marketplace.internal.http.GetPublicationPackageConverter;
import com.oracle.bmc.marketplace.internal.http.ListAcceptedAgreementsConverter;
import com.oracle.bmc.marketplace.internal.http.ListAgreementsConverter;
import com.oracle.bmc.marketplace.internal.http.ListCategoriesConverter;
import com.oracle.bmc.marketplace.internal.http.ListListingsConverter;
import com.oracle.bmc.marketplace.internal.http.ListPackagesConverter;
import com.oracle.bmc.marketplace.internal.http.ListPublicationPackagesConverter;
import com.oracle.bmc.marketplace.internal.http.ListPublicationsConverter;
import com.oracle.bmc.marketplace.internal.http.ListPublishersConverter;
import com.oracle.bmc.marketplace.internal.http.ListReportTypesConverter;
import com.oracle.bmc.marketplace.internal.http.ListReportsConverter;
import com.oracle.bmc.marketplace.internal.http.ListTaxesConverter;
import com.oracle.bmc.marketplace.internal.http.UpdateAcceptedAgreementConverter;
import com.oracle.bmc.marketplace.internal.http.UpdatePublicationConverter;
import com.oracle.bmc.marketplace.requests.ChangePublicationCompartmentRequest;
import com.oracle.bmc.marketplace.requests.CreateAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.CreatePublicationRequest;
import com.oracle.bmc.marketplace.requests.DeleteAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.DeletePublicationRequest;
import com.oracle.bmc.marketplace.requests.GetAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.GetAgreementRequest;
import com.oracle.bmc.marketplace.requests.GetListingRequest;
import com.oracle.bmc.marketplace.requests.GetPackageRequest;
import com.oracle.bmc.marketplace.requests.GetPublicationPackageRequest;
import com.oracle.bmc.marketplace.requests.GetPublicationRequest;
import com.oracle.bmc.marketplace.requests.ListAcceptedAgreementsRequest;
import com.oracle.bmc.marketplace.requests.ListAgreementsRequest;
import com.oracle.bmc.marketplace.requests.ListCategoriesRequest;
import com.oracle.bmc.marketplace.requests.ListListingsRequest;
import com.oracle.bmc.marketplace.requests.ListPackagesRequest;
import com.oracle.bmc.marketplace.requests.ListPublicationPackagesRequest;
import com.oracle.bmc.marketplace.requests.ListPublicationsRequest;
import com.oracle.bmc.marketplace.requests.ListPublishersRequest;
import com.oracle.bmc.marketplace.requests.ListReportTypesRequest;
import com.oracle.bmc.marketplace.requests.ListReportsRequest;
import com.oracle.bmc.marketplace.requests.ListTaxesRequest;
import com.oracle.bmc.marketplace.requests.UpdateAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.UpdatePublicationRequest;
import com.oracle.bmc.marketplace.responses.ChangePublicationCompartmentResponse;
import com.oracle.bmc.marketplace.responses.CreateAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.CreatePublicationResponse;
import com.oracle.bmc.marketplace.responses.DeleteAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.DeletePublicationResponse;
import com.oracle.bmc.marketplace.responses.GetAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.GetAgreementResponse;
import com.oracle.bmc.marketplace.responses.GetListingResponse;
import com.oracle.bmc.marketplace.responses.GetPackageResponse;
import com.oracle.bmc.marketplace.responses.GetPublicationPackageResponse;
import com.oracle.bmc.marketplace.responses.GetPublicationResponse;
import com.oracle.bmc.marketplace.responses.ListAcceptedAgreementsResponse;
import com.oracle.bmc.marketplace.responses.ListAgreementsResponse;
import com.oracle.bmc.marketplace.responses.ListCategoriesResponse;
import com.oracle.bmc.marketplace.responses.ListListingsResponse;
import com.oracle.bmc.marketplace.responses.ListPackagesResponse;
import com.oracle.bmc.marketplace.responses.ListPublicationPackagesResponse;
import com.oracle.bmc.marketplace.responses.ListPublicationsResponse;
import com.oracle.bmc.marketplace.responses.ListPublishersResponse;
import com.oracle.bmc.marketplace.responses.ListReportTypesResponse;
import com.oracle.bmc.marketplace.responses.ListReportsResponse;
import com.oracle.bmc.marketplace.responses.ListTaxesResponse;
import com.oracle.bmc.marketplace.responses.UpdateAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.UpdatePublicationResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketplaceAsyncClient
implements MarketplaceAsync {
    private static final Logger LOG = LoggerFactory.getLogger(MarketplaceAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MARKETPLACE").serviceEndpointPrefix("").serviceEndpointTemplate("https://marketplace.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public MarketplaceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public MarketplaceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public MarketplaceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public MarketplaceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public MarketplaceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public MarketplaceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public MarketplaceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public MarketplaceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangePublicationCompartmentResponse> changePublicationCompartment(ChangePublicationCompartmentRequest request, AsyncHandler<ChangePublicationCompartmentRequest, ChangePublicationCompartmentResponse> handler) {
        LOG.trace("Called async changePublicationCompartment");
        ChangePublicationCompartmentRequest interceptedRequest = ChangePublicationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangePublicationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangePublicationCompartmentResponse> transformer = ChangePublicationCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangePublicationCompartmentRequest, ChangePublicationCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangePublicationCompartmentRequest, ChangePublicationCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateAcceptedAgreementResponse> createAcceptedAgreement(CreateAcceptedAgreementRequest request, AsyncHandler<CreateAcceptedAgreementRequest, CreateAcceptedAgreementResponse> handler) {
        LOG.trace("Called async createAcceptedAgreement");
        CreateAcceptedAgreementRequest interceptedRequest = CreateAcceptedAgreementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAcceptedAgreementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAcceptedAgreementResponse> transformer = CreateAcceptedAgreementConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateAcceptedAgreementRequest, CreateAcceptedAgreementResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateAcceptedAgreementRequest, CreateAcceptedAgreementResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePublicationResponse> createPublication(CreatePublicationRequest request, AsyncHandler<CreatePublicationRequest, CreatePublicationResponse> handler) {
        LOG.trace("Called async createPublication");
        CreatePublicationRequest interceptedRequest = CreatePublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePublicationResponse> transformer = CreatePublicationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreatePublicationRequest, CreatePublicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePublicationRequest, CreatePublicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAcceptedAgreementResponse> deleteAcceptedAgreement(DeleteAcceptedAgreementRequest request, AsyncHandler<DeleteAcceptedAgreementRequest, DeleteAcceptedAgreementResponse> handler) {
        LOG.trace("Called async deleteAcceptedAgreement");
        DeleteAcceptedAgreementRequest interceptedRequest = DeleteAcceptedAgreementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAcceptedAgreementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAcceptedAgreementResponse> transformer = DeleteAcceptedAgreementConverter.fromResponse();
        AsyncHandler<DeleteAcceptedAgreementRequest, DeleteAcceptedAgreementResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAcceptedAgreementRequest, DeleteAcceptedAgreementResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePublicationResponse> deletePublication(DeletePublicationRequest request, AsyncHandler<DeletePublicationRequest, DeletePublicationResponse> handler) {
        LOG.trace("Called async deletePublication");
        DeletePublicationRequest interceptedRequest = DeletePublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePublicationResponse> transformer = DeletePublicationConverter.fromResponse();
        AsyncHandler<DeletePublicationRequest, DeletePublicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePublicationRequest, DeletePublicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAcceptedAgreementResponse> getAcceptedAgreement(GetAcceptedAgreementRequest request, AsyncHandler<GetAcceptedAgreementRequest, GetAcceptedAgreementResponse> handler) {
        LOG.trace("Called async getAcceptedAgreement");
        GetAcceptedAgreementRequest interceptedRequest = GetAcceptedAgreementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAcceptedAgreementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAcceptedAgreementResponse> transformer = GetAcceptedAgreementConverter.fromResponse();
        AsyncHandler<GetAcceptedAgreementRequest, GetAcceptedAgreementResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAcceptedAgreementRequest, GetAcceptedAgreementResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAgreementResponse> getAgreement(GetAgreementRequest request, AsyncHandler<GetAgreementRequest, GetAgreementResponse> handler) {
        LOG.trace("Called async getAgreement");
        GetAgreementRequest interceptedRequest = GetAgreementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAgreementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAgreementResponse> transformer = GetAgreementConverter.fromResponse();
        AsyncHandler<GetAgreementRequest, GetAgreementResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAgreementRequest, GetAgreementResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetListingResponse> getListing(GetListingRequest request, AsyncHandler<GetListingRequest, GetListingResponse> handler) {
        LOG.trace("Called async getListing");
        GetListingRequest interceptedRequest = GetListingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetListingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetListingResponse> transformer = GetListingConverter.fromResponse();
        AsyncHandler<GetListingRequest, GetListingResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetListingRequest, GetListingResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPackageResponse> getPackage(GetPackageRequest request, AsyncHandler<GetPackageRequest, GetPackageResponse> handler) {
        LOG.trace("Called async getPackage");
        GetPackageRequest interceptedRequest = GetPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPackageResponse> transformer = GetPackageConverter.fromResponse();
        AsyncHandler<GetPackageRequest, GetPackageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPackageRequest, GetPackageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPublicationResponse> getPublication(GetPublicationRequest request, AsyncHandler<GetPublicationRequest, GetPublicationResponse> handler) {
        LOG.trace("Called async getPublication");
        GetPublicationRequest interceptedRequest = GetPublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPublicationResponse> transformer = GetPublicationConverter.fromResponse();
        AsyncHandler<GetPublicationRequest, GetPublicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPublicationRequest, GetPublicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPublicationPackageResponse> getPublicationPackage(GetPublicationPackageRequest request, AsyncHandler<GetPublicationPackageRequest, GetPublicationPackageResponse> handler) {
        LOG.trace("Called async getPublicationPackage");
        GetPublicationPackageRequest interceptedRequest = GetPublicationPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPublicationPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPublicationPackageResponse> transformer = GetPublicationPackageConverter.fromResponse();
        AsyncHandler<GetPublicationPackageRequest, GetPublicationPackageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPublicationPackageRequest, GetPublicationPackageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAcceptedAgreementsResponse> listAcceptedAgreements(ListAcceptedAgreementsRequest request, AsyncHandler<ListAcceptedAgreementsRequest, ListAcceptedAgreementsResponse> handler) {
        LOG.trace("Called async listAcceptedAgreements");
        ListAcceptedAgreementsRequest interceptedRequest = ListAcceptedAgreementsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAcceptedAgreementsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAcceptedAgreementsResponse> transformer = ListAcceptedAgreementsConverter.fromResponse();
        AsyncHandler<ListAcceptedAgreementsRequest, ListAcceptedAgreementsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAcceptedAgreementsRequest, ListAcceptedAgreementsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAgreementsResponse> listAgreements(ListAgreementsRequest request, AsyncHandler<ListAgreementsRequest, ListAgreementsResponse> handler) {
        LOG.trace("Called async listAgreements");
        ListAgreementsRequest interceptedRequest = ListAgreementsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAgreementsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAgreementsResponse> transformer = ListAgreementsConverter.fromResponse();
        AsyncHandler<ListAgreementsRequest, ListAgreementsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAgreementsRequest, ListAgreementsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCategoriesResponse> listCategories(ListCategoriesRequest request, AsyncHandler<ListCategoriesRequest, ListCategoriesResponse> handler) {
        LOG.trace("Called async listCategories");
        ListCategoriesRequest interceptedRequest = ListCategoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCategoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCategoriesResponse> transformer = ListCategoriesConverter.fromResponse();
        AsyncHandler<ListCategoriesRequest, ListCategoriesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCategoriesRequest, ListCategoriesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListListingsResponse> listListings(ListListingsRequest request, AsyncHandler<ListListingsRequest, ListListingsResponse> handler) {
        LOG.trace("Called async listListings");
        ListListingsRequest interceptedRequest = ListListingsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListListingsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListListingsResponse> transformer = ListListingsConverter.fromResponse();
        AsyncHandler<ListListingsRequest, ListListingsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListListingsRequest, ListListingsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPackagesResponse> listPackages(ListPackagesRequest request, AsyncHandler<ListPackagesRequest, ListPackagesResponse> handler) {
        LOG.trace("Called async listPackages");
        ListPackagesRequest interceptedRequest = ListPackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPackagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPackagesResponse> transformer = ListPackagesConverter.fromResponse();
        AsyncHandler<ListPackagesRequest, ListPackagesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPackagesRequest, ListPackagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPublicationPackagesResponse> listPublicationPackages(ListPublicationPackagesRequest request, AsyncHandler<ListPublicationPackagesRequest, ListPublicationPackagesResponse> handler) {
        LOG.trace("Called async listPublicationPackages");
        ListPublicationPackagesRequest interceptedRequest = ListPublicationPackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPublicationPackagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPublicationPackagesResponse> transformer = ListPublicationPackagesConverter.fromResponse();
        AsyncHandler<ListPublicationPackagesRequest, ListPublicationPackagesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPublicationPackagesRequest, ListPublicationPackagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPublicationsResponse> listPublications(ListPublicationsRequest request, AsyncHandler<ListPublicationsRequest, ListPublicationsResponse> handler) {
        LOG.trace("Called async listPublications");
        ListPublicationsRequest interceptedRequest = ListPublicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPublicationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPublicationsResponse> transformer = ListPublicationsConverter.fromResponse();
        AsyncHandler<ListPublicationsRequest, ListPublicationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPublicationsRequest, ListPublicationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPublishersResponse> listPublishers(ListPublishersRequest request, AsyncHandler<ListPublishersRequest, ListPublishersResponse> handler) {
        LOG.trace("Called async listPublishers");
        ListPublishersRequest interceptedRequest = ListPublishersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPublishersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPublishersResponse> transformer = ListPublishersConverter.fromResponse();
        AsyncHandler<ListPublishersRequest, ListPublishersResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPublishersRequest, ListPublishersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListReportTypesResponse> listReportTypes(ListReportTypesRequest request, AsyncHandler<ListReportTypesRequest, ListReportTypesResponse> handler) {
        LOG.trace("Called async listReportTypes");
        ListReportTypesRequest interceptedRequest = ListReportTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListReportTypesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListReportTypesResponse> transformer = ListReportTypesConverter.fromResponse();
        AsyncHandler<ListReportTypesRequest, ListReportTypesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListReportTypesRequest, ListReportTypesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListReportsResponse> listReports(ListReportsRequest request, AsyncHandler<ListReportsRequest, ListReportsResponse> handler) {
        LOG.trace("Called async listReports");
        ListReportsRequest interceptedRequest = ListReportsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListReportsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListReportsResponse> transformer = ListReportsConverter.fromResponse();
        AsyncHandler<ListReportsRequest, ListReportsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListReportsRequest, ListReportsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTaxesResponse> listTaxes(ListTaxesRequest request, AsyncHandler<ListTaxesRequest, ListTaxesResponse> handler) {
        LOG.trace("Called async listTaxes");
        ListTaxesRequest interceptedRequest = ListTaxesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaxesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTaxesResponse> transformer = ListTaxesConverter.fromResponse();
        AsyncHandler<ListTaxesRequest, ListTaxesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTaxesRequest, ListTaxesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAcceptedAgreementResponse> updateAcceptedAgreement(UpdateAcceptedAgreementRequest request, AsyncHandler<UpdateAcceptedAgreementRequest, UpdateAcceptedAgreementResponse> handler) {
        LOG.trace("Called async updateAcceptedAgreement");
        UpdateAcceptedAgreementRequest interceptedRequest = UpdateAcceptedAgreementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAcceptedAgreementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAcceptedAgreementResponse> transformer = UpdateAcceptedAgreementConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateAcceptedAgreementRequest, UpdateAcceptedAgreementResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAcceptedAgreementRequest, UpdateAcceptedAgreementResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdatePublicationResponse> updatePublication(UpdatePublicationRequest request, AsyncHandler<UpdatePublicationRequest, UpdatePublicationResponse> handler) {
        LOG.trace("Called async updatePublication");
        UpdatePublicationRequest interceptedRequest = UpdatePublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePublicationResponse> transformer = UpdatePublicationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdatePublicationRequest, UpdatePublicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdatePublicationRequest, UpdatePublicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MarketplaceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public MarketplaceAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new MarketplaceAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

