/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.marketplace.Marketplace;
import com.oracle.bmc.marketplace.model.AcceptedAgreementSummary;
import com.oracle.bmc.marketplace.model.AgreementSummary;
import com.oracle.bmc.marketplace.model.CategorySummary;
import com.oracle.bmc.marketplace.model.ListingPackageSummary;
import com.oracle.bmc.marketplace.model.ListingSummary;
import com.oracle.bmc.marketplace.model.PublicationPackageSummary;
import com.oracle.bmc.marketplace.model.PublicationSummary;
import com.oracle.bmc.marketplace.model.PublisherSummary;
import com.oracle.bmc.marketplace.model.ReportSummary;
import com.oracle.bmc.marketplace.model.ReportTypeSummary;
import com.oracle.bmc.marketplace.requests.ListAcceptedAgreementsRequest;
import com.oracle.bmc.marketplace.requests.ListAgreementsRequest;
import com.oracle.bmc.marketplace.requests.ListCategoriesRequest;
import com.oracle.bmc.marketplace.requests.ListListingsRequest;
import com.oracle.bmc.marketplace.requests.ListPackagesRequest;
import com.oracle.bmc.marketplace.requests.ListPublicationPackagesRequest;
import com.oracle.bmc.marketplace.requests.ListPublicationsRequest;
import com.oracle.bmc.marketplace.requests.ListPublishersRequest;
import com.oracle.bmc.marketplace.requests.ListReportTypesRequest;
import com.oracle.bmc.marketplace.requests.ListReportsRequest;
import com.oracle.bmc.marketplace.responses.ListAcceptedAgreementsResponse;
import com.oracle.bmc.marketplace.responses.ListAgreementsResponse;
import com.oracle.bmc.marketplace.responses.ListCategoriesResponse;
import com.oracle.bmc.marketplace.responses.ListListingsResponse;
import com.oracle.bmc.marketplace.responses.ListPackagesResponse;
import com.oracle.bmc.marketplace.responses.ListPublicationPackagesResponse;
import com.oracle.bmc.marketplace.responses.ListPublicationsResponse;
import com.oracle.bmc.marketplace.responses.ListPublishersResponse;
import com.oracle.bmc.marketplace.responses.ListReportTypesResponse;
import com.oracle.bmc.marketplace.responses.ListReportsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class MarketplacePaginators {
    private final Marketplace client;

    public Iterable<ListAcceptedAgreementsResponse> listAcceptedAgreementsResponseIterator(final ListAcceptedAgreementsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAcceptedAgreementsRequest.Builder>(){

            public ListAcceptedAgreementsRequest.Builder get() {
                return ListAcceptedAgreementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAcceptedAgreementsResponse, String>(){

            public String apply(ListAcceptedAgreementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAcceptedAgreementsRequest.Builder>, ListAcceptedAgreementsRequest>(){

            public ListAcceptedAgreementsRequest apply(RequestBuilderAndToken<ListAcceptedAgreementsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAcceptedAgreementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAcceptedAgreementsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAcceptedAgreementsRequest, ListAcceptedAgreementsResponse>(){

            public ListAcceptedAgreementsResponse apply(ListAcceptedAgreementsRequest request) {
                return MarketplacePaginators.this.client.listAcceptedAgreements(request);
            }
        });
    }

    public Iterable<AcceptedAgreementSummary> listAcceptedAgreementsRecordIterator(final ListAcceptedAgreementsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAcceptedAgreementsRequest.Builder>(){

            public ListAcceptedAgreementsRequest.Builder get() {
                return ListAcceptedAgreementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAcceptedAgreementsResponse, String>(){

            public String apply(ListAcceptedAgreementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAcceptedAgreementsRequest.Builder>, ListAcceptedAgreementsRequest>(){

            public ListAcceptedAgreementsRequest apply(RequestBuilderAndToken<ListAcceptedAgreementsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAcceptedAgreementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAcceptedAgreementsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAcceptedAgreementsRequest, ListAcceptedAgreementsResponse>(){

            public ListAcceptedAgreementsResponse apply(ListAcceptedAgreementsRequest request) {
                return MarketplacePaginators.this.client.listAcceptedAgreements(request);
            }
        }, (Function)new Function<ListAcceptedAgreementsResponse, List<AcceptedAgreementSummary>>(){

            public List<AcceptedAgreementSummary> apply(ListAcceptedAgreementsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAgreementsResponse> listAgreementsResponseIterator(final ListAgreementsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAgreementsRequest.Builder>(){

            public ListAgreementsRequest.Builder get() {
                return ListAgreementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgreementsResponse, String>(){

            public String apply(ListAgreementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgreementsRequest.Builder>, ListAgreementsRequest>(){

            public ListAgreementsRequest apply(RequestBuilderAndToken<ListAgreementsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAgreementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgreementsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAgreementsRequest, ListAgreementsResponse>(){

            public ListAgreementsResponse apply(ListAgreementsRequest request) {
                return MarketplacePaginators.this.client.listAgreements(request);
            }
        });
    }

    public Iterable<AgreementSummary> listAgreementsRecordIterator(final ListAgreementsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAgreementsRequest.Builder>(){

            public ListAgreementsRequest.Builder get() {
                return ListAgreementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgreementsResponse, String>(){

            public String apply(ListAgreementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgreementsRequest.Builder>, ListAgreementsRequest>(){

            public ListAgreementsRequest apply(RequestBuilderAndToken<ListAgreementsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAgreementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgreementsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAgreementsRequest, ListAgreementsResponse>(){

            public ListAgreementsResponse apply(ListAgreementsRequest request) {
                return MarketplacePaginators.this.client.listAgreements(request);
            }
        }, (Function)new Function<ListAgreementsResponse, List<AgreementSummary>>(){

            public List<AgreementSummary> apply(ListAgreementsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListCategoriesResponse> listCategoriesResponseIterator(final ListCategoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCategoriesRequest.Builder>(){

            public ListCategoriesRequest.Builder get() {
                return ListCategoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCategoriesResponse, String>(){

            public String apply(ListCategoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCategoriesRequest.Builder>, ListCategoriesRequest>(){

            public ListCategoriesRequest apply(RequestBuilderAndToken<ListCategoriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListCategoriesRequest, ListCategoriesResponse>(){

            public ListCategoriesResponse apply(ListCategoriesRequest request) {
                return MarketplacePaginators.this.client.listCategories(request);
            }
        });
    }

    public Iterable<CategorySummary> listCategoriesRecordIterator(final ListCategoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCategoriesRequest.Builder>(){

            public ListCategoriesRequest.Builder get() {
                return ListCategoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCategoriesResponse, String>(){

            public String apply(ListCategoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCategoriesRequest.Builder>, ListCategoriesRequest>(){

            public ListCategoriesRequest apply(RequestBuilderAndToken<ListCategoriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListCategoriesRequest, ListCategoriesResponse>(){

            public ListCategoriesResponse apply(ListCategoriesRequest request) {
                return MarketplacePaginators.this.client.listCategories(request);
            }
        }, (Function)new Function<ListCategoriesResponse, List<CategorySummary>>(){

            public List<CategorySummary> apply(ListCategoriesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListListingsResponse> listListingsResponseIterator(final ListListingsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListListingsRequest.Builder>(){

            public ListListingsRequest.Builder get() {
                return ListListingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListListingsResponse, String>(){

            public String apply(ListListingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListListingsRequest.Builder>, ListListingsRequest>(){

            public ListListingsRequest apply(RequestBuilderAndToken<ListListingsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListListingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListListingsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListListingsRequest, ListListingsResponse>(){

            public ListListingsResponse apply(ListListingsRequest request) {
                return MarketplacePaginators.this.client.listListings(request);
            }
        });
    }

    public Iterable<ListingSummary> listListingsRecordIterator(final ListListingsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListListingsRequest.Builder>(){

            public ListListingsRequest.Builder get() {
                return ListListingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListListingsResponse, String>(){

            public String apply(ListListingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListListingsRequest.Builder>, ListListingsRequest>(){

            public ListListingsRequest apply(RequestBuilderAndToken<ListListingsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListListingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListListingsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListListingsRequest, ListListingsResponse>(){

            public ListListingsResponse apply(ListListingsRequest request) {
                return MarketplacePaginators.this.client.listListings(request);
            }
        }, (Function)new Function<ListListingsResponse, List<ListingSummary>>(){

            public List<ListingSummary> apply(ListListingsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPackagesResponse> listPackagesResponseIterator(final ListPackagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPackagesRequest.Builder>(){

            public ListPackagesRequest.Builder get() {
                return ListPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPackagesResponse, String>(){

            public String apply(ListPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPackagesRequest.Builder>, ListPackagesRequest>(){

            public ListPackagesRequest apply(RequestBuilderAndToken<ListPackagesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPackagesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPackagesRequest, ListPackagesResponse>(){

            public ListPackagesResponse apply(ListPackagesRequest request) {
                return MarketplacePaginators.this.client.listPackages(request);
            }
        });
    }

    public Iterable<ListingPackageSummary> listPackagesRecordIterator(final ListPackagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPackagesRequest.Builder>(){

            public ListPackagesRequest.Builder get() {
                return ListPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPackagesResponse, String>(){

            public String apply(ListPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPackagesRequest.Builder>, ListPackagesRequest>(){

            public ListPackagesRequest apply(RequestBuilderAndToken<ListPackagesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPackagesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPackagesRequest, ListPackagesResponse>(){

            public ListPackagesResponse apply(ListPackagesRequest request) {
                return MarketplacePaginators.this.client.listPackages(request);
            }
        }, (Function)new Function<ListPackagesResponse, List<ListingPackageSummary>>(){

            public List<ListingPackageSummary> apply(ListPackagesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPublicationPackagesResponse> listPublicationPackagesResponseIterator(final ListPublicationPackagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPublicationPackagesRequest.Builder>(){

            public ListPublicationPackagesRequest.Builder get() {
                return ListPublicationPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublicationPackagesResponse, String>(){

            public String apply(ListPublicationPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublicationPackagesRequest.Builder>, ListPublicationPackagesRequest>(){

            public ListPublicationPackagesRequest apply(RequestBuilderAndToken<ListPublicationPackagesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPublicationPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublicationPackagesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPublicationPackagesRequest, ListPublicationPackagesResponse>(){

            public ListPublicationPackagesResponse apply(ListPublicationPackagesRequest request) {
                return MarketplacePaginators.this.client.listPublicationPackages(request);
            }
        });
    }

    public Iterable<PublicationPackageSummary> listPublicationPackagesRecordIterator(final ListPublicationPackagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPublicationPackagesRequest.Builder>(){

            public ListPublicationPackagesRequest.Builder get() {
                return ListPublicationPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublicationPackagesResponse, String>(){

            public String apply(ListPublicationPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublicationPackagesRequest.Builder>, ListPublicationPackagesRequest>(){

            public ListPublicationPackagesRequest apply(RequestBuilderAndToken<ListPublicationPackagesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPublicationPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublicationPackagesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPublicationPackagesRequest, ListPublicationPackagesResponse>(){

            public ListPublicationPackagesResponse apply(ListPublicationPackagesRequest request) {
                return MarketplacePaginators.this.client.listPublicationPackages(request);
            }
        }, (Function)new Function<ListPublicationPackagesResponse, List<PublicationPackageSummary>>(){

            public List<PublicationPackageSummary> apply(ListPublicationPackagesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPublicationsResponse> listPublicationsResponseIterator(final ListPublicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPublicationsRequest.Builder>(){

            public ListPublicationsRequest.Builder get() {
                return ListPublicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublicationsResponse, String>(){

            public String apply(ListPublicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublicationsRequest.Builder>, ListPublicationsRequest>(){

            public ListPublicationsRequest apply(RequestBuilderAndToken<ListPublicationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPublicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublicationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPublicationsRequest, ListPublicationsResponse>(){

            public ListPublicationsResponse apply(ListPublicationsRequest request) {
                return MarketplacePaginators.this.client.listPublications(request);
            }
        });
    }

    public Iterable<PublicationSummary> listPublicationsRecordIterator(final ListPublicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPublicationsRequest.Builder>(){

            public ListPublicationsRequest.Builder get() {
                return ListPublicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublicationsResponse, String>(){

            public String apply(ListPublicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublicationsRequest.Builder>, ListPublicationsRequest>(){

            public ListPublicationsRequest apply(RequestBuilderAndToken<ListPublicationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPublicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublicationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPublicationsRequest, ListPublicationsResponse>(){

            public ListPublicationsResponse apply(ListPublicationsRequest request) {
                return MarketplacePaginators.this.client.listPublications(request);
            }
        }, (Function)new Function<ListPublicationsResponse, List<PublicationSummary>>(){

            public List<PublicationSummary> apply(ListPublicationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPublishersResponse> listPublishersResponseIterator(final ListPublishersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPublishersRequest.Builder>(){

            public ListPublishersRequest.Builder get() {
                return ListPublishersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublishersResponse, String>(){

            public String apply(ListPublishersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublishersRequest.Builder>, ListPublishersRequest>(){

            public ListPublishersRequest apply(RequestBuilderAndToken<ListPublishersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPublishersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublishersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPublishersRequest, ListPublishersResponse>(){

            public ListPublishersResponse apply(ListPublishersRequest request) {
                return MarketplacePaginators.this.client.listPublishers(request);
            }
        });
    }

    public Iterable<PublisherSummary> listPublishersRecordIterator(final ListPublishersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPublishersRequest.Builder>(){

            public ListPublishersRequest.Builder get() {
                return ListPublishersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublishersResponse, String>(){

            public String apply(ListPublishersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublishersRequest.Builder>, ListPublishersRequest>(){

            public ListPublishersRequest apply(RequestBuilderAndToken<ListPublishersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPublishersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublishersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPublishersRequest, ListPublishersResponse>(){

            public ListPublishersResponse apply(ListPublishersRequest request) {
                return MarketplacePaginators.this.client.listPublishers(request);
            }
        }, (Function)new Function<ListPublishersResponse, List<PublisherSummary>>(){

            public List<PublisherSummary> apply(ListPublishersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListReportTypesResponse> listReportTypesResponseIterator(final ListReportTypesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReportTypesRequest.Builder>(){

            public ListReportTypesRequest.Builder get() {
                return ListReportTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReportTypesResponse, String>(){

            public String apply(ListReportTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReportTypesRequest.Builder>, ListReportTypesRequest>(){

            public ListReportTypesRequest apply(RequestBuilderAndToken<ListReportTypesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListReportTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReportTypesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListReportTypesRequest, ListReportTypesResponse>(){

            public ListReportTypesResponse apply(ListReportTypesRequest request) {
                return MarketplacePaginators.this.client.listReportTypes(request);
            }
        });
    }

    public Iterable<ReportTypeSummary> listReportTypesRecordIterator(final ListReportTypesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReportTypesRequest.Builder>(){

            public ListReportTypesRequest.Builder get() {
                return ListReportTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReportTypesResponse, String>(){

            public String apply(ListReportTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReportTypesRequest.Builder>, ListReportTypesRequest>(){

            public ListReportTypesRequest apply(RequestBuilderAndToken<ListReportTypesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListReportTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReportTypesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListReportTypesRequest, ListReportTypesResponse>(){

            public ListReportTypesResponse apply(ListReportTypesRequest request) {
                return MarketplacePaginators.this.client.listReportTypes(request);
            }
        }, (Function)new Function<ListReportTypesResponse, List<ReportTypeSummary>>(){

            public List<ReportTypeSummary> apply(ListReportTypesResponse response) {
                return response.getReportTypeCollection().getItems();
            }
        });
    }

    public Iterable<ListReportsResponse> listReportsResponseIterator(final ListReportsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReportsRequest.Builder>(){

            public ListReportsRequest.Builder get() {
                return ListReportsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReportsResponse, String>(){

            public String apply(ListReportsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReportsRequest.Builder>, ListReportsRequest>(){

            public ListReportsRequest apply(RequestBuilderAndToken<ListReportsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListReportsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReportsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListReportsRequest, ListReportsResponse>(){

            public ListReportsResponse apply(ListReportsRequest request) {
                return MarketplacePaginators.this.client.listReports(request);
            }
        });
    }

    public Iterable<ReportSummary> listReportsRecordIterator(final ListReportsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReportsRequest.Builder>(){

            public ListReportsRequest.Builder get() {
                return ListReportsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReportsResponse, String>(){

            public String apply(ListReportsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReportsRequest.Builder>, ListReportsRequest>(){

            public ListReportsRequest apply(RequestBuilderAndToken<ListReportsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListReportsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReportsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListReportsRequest, ListReportsResponse>(){

            public ListReportsResponse apply(ListReportsRequest request) {
                return MarketplacePaginators.this.client.listReports(request);
            }
        }, (Function)new Function<ListReportsResponse, List<ReportSummary>>(){

            public List<ReportSummary> apply(ListReportsResponse response) {
                return response.getReportCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public MarketplacePaginators(Marketplace client) {
        this.client = client;
    }
}

