/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.marketplace.model.Agreement;
import com.oracle.bmc.marketplace.requests.GetAgreementRequest;
import com.oracle.bmc.marketplace.responses.GetAgreementResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAgreementConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetAgreementConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetAgreementRequest interceptRequest(GetAgreementRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetAgreementRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getPackageVersion(), (String)"packageVersion must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAgreementId(), (String)"agreementId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181001").path("listings").path(HttpUtils.encodePathSegment((String)request.getListingId())).path("packages").path(HttpUtils.encodePathSegment((String)request.getPackageVersion())).path("agreements").path(HttpUtils.encodePathSegment((String)request.getAgreementId()));
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetAgreementResponse> fromResponse() {
        Function<Response, GetAgreementResponse> transformer = new Function<Response, GetAgreementResponse>(){

            public GetAgreementResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.marketplace.responses.GetAgreementResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Agreement.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetAgreementResponse.Builder builder = GetAgreementResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.agreement((Agreement)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetAgreementResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

