/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.marketplace.model.ListingPackage;
import com.oracle.bmc.marketplace.requests.GetPackageRequest;
import com.oracle.bmc.marketplace.responses.GetPackageResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPackageConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetPackageConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetPackageRequest interceptRequest(GetPackageRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetPackageRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getPackageVersion(), (String)"packageVersion must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181001").path("listings").path(HttpUtils.encodePathSegment((String)request.getListingId())).path("packages").path(HttpUtils.encodePathSegment((String)request.getPackageVersion()));
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetPackageResponse> fromResponse() {
        Function<Response, GetPackageResponse> transformer = new Function<Response, GetPackageResponse>(){

            public GetPackageResponse apply(Response rawResponse) {
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.marketplace.responses.GetPackageResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ListingPackage.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetPackageResponse.Builder builder = GetPackageResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.listingPackage((ListingPackage)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                GetPackageResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

