/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAgreementRequest
extends BmcRequest<Void> {
    private String listingId;
    private String packageVersion;
    private String agreementId;
    private String opcRequestId;
    private String compartmentId;

    @ConstructorProperties(value={"listingId", "packageVersion", "agreementId", "opcRequestId", "compartmentId"})
    GetAgreementRequest(String listingId, String packageVersion, String agreementId, String opcRequestId, String compartmentId) {
        this.listingId = listingId;
        this.packageVersion = packageVersion;
        this.agreementId = agreementId;
        this.opcRequestId = opcRequestId;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getAgreementId() {
        return this.agreementId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAgreementRequest, Void> {
        private String listingId;
        private String packageVersion;
        private String agreementId;
        private String opcRequestId;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAgreementRequest o) {
            this.listingId(o.getListingId());
            this.packageVersion(o.getPackageVersion());
            this.agreementId(o.getAgreementId());
            this.opcRequestId(o.getOpcRequestId());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAgreementRequest build() {
            GetAgreementRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public GetAgreementRequest buildWithoutInvocationCallback() {
            return new GetAgreementRequest(this.listingId, this.packageVersion, this.agreementId, this.opcRequestId, this.compartmentId);
        }

        public String toString() {
            return "GetAgreementRequest.Builder(listingId=" + this.listingId + ", packageVersion=" + this.packageVersion + ", agreementId=" + this.agreementId + ", opcRequestId=" + this.opcRequestId + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

