/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPublicationRequest
extends BmcRequest<Void> {
    private String publicationId;
    private String opcRequestId;

    @ConstructorProperties(value={"publicationId", "opcRequestId"})
    GetPublicationRequest(String publicationId, String opcRequestId) {
        this.publicationId = publicationId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPublicationId() {
        return this.publicationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPublicationRequest, Void> {
        private String publicationId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPublicationRequest o) {
            this.publicationId(o.getPublicationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPublicationRequest build() {
            GetPublicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder publicationId(String publicationId) {
            this.publicationId = publicationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetPublicationRequest buildWithoutInvocationCallback() {
            return new GetPublicationRequest(this.publicationId, this.opcRequestId);
        }

        public String toString() {
            return "GetPublicationRequest.Builder(publicationId=" + this.publicationId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

