/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.mysql.Channels;
import com.oracle.bmc.mysql.model.ChannelSummary;
import com.oracle.bmc.mysql.requests.ListChannelsRequest;
import com.oracle.bmc.mysql.responses.ListChannelsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class ChannelsPaginators {
    private final Channels client;

    public Iterable<ListChannelsResponse> listChannelsResponseIterator(final ListChannelsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListChannelsRequest.Builder>(){

            public ListChannelsRequest.Builder get() {
                return ListChannelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListChannelsResponse, String>(){

            public String apply(ListChannelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListChannelsRequest.Builder>, ListChannelsRequest>(){

            public ListChannelsRequest apply(RequestBuilderAndToken<ListChannelsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListChannelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListChannelsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListChannelsRequest, ListChannelsResponse>(){

            public ListChannelsResponse apply(ListChannelsRequest request) {
                return ChannelsPaginators.this.client.listChannels(request);
            }
        });
    }

    public Iterable<ChannelSummary> listChannelsRecordIterator(final ListChannelsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListChannelsRequest.Builder>(){

            public ListChannelsRequest.Builder get() {
                return ListChannelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListChannelsResponse, String>(){

            public String apply(ListChannelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListChannelsRequest.Builder>, ListChannelsRequest>(){

            public ListChannelsRequest apply(RequestBuilderAndToken<ListChannelsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListChannelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListChannelsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListChannelsRequest, ListChannelsResponse>(){

            public ListChannelsResponse apply(ListChannelsRequest request) {
                return ChannelsPaginators.this.client.listChannels(request);
            }
        }, (Function)new Function<ListChannelsResponse, List<ChannelSummary>>(){

            public List<ChannelSummary> apply(ListChannelsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ChannelsPaginators(Channels client) {
        this.client = client;
    }
}

