/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.mysql.Channels;
import com.oracle.bmc.mysql.model.Channel;
import com.oracle.bmc.mysql.requests.GetChannelRequest;
import com.oracle.bmc.mysql.responses.GetChannelResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class ChannelsWaiters {
    private final ExecutorService executorService;
    private final Channels client;

    public Waiter<GetChannelRequest, GetChannelResponse> forChannel(GetChannelRequest request, Channel.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forChannel(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetChannelRequest, GetChannelResponse> forChannel(GetChannelRequest request, Channel.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forChannel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetChannelRequest, GetChannelResponse> forChannel(GetChannelRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Channel.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forChannel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetChannelRequest, GetChannelResponse> forChannel(BmcGenericWaiter waiter, GetChannelRequest request, Channel.LifecycleState ... targetStates) {
        final HashSet<Channel.LifecycleState> targetStatesSet = new HashSet<Channel.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetChannelRequest, GetChannelResponse>(){

            public GetChannelResponse apply(GetChannelRequest request) {
                return ChannelsWaiters.this.client.getChannel(request);
            }
        }, (Predicate)new Predicate<GetChannelResponse>(){

            public boolean apply(GetChannelResponse response) {
                return targetStatesSet.contains((Object)response.getChannel().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Channel.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public ChannelsWaiters(ExecutorService executorService, Channels client) {
        this.executorService = executorService;
        this.client = client;
    }
}

