/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.mysql.DbSystemAsync;
import com.oracle.bmc.mysql.internal.http.AddAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.AddHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.CreateDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.DeleteAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.DeleteDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.DeleteHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.GenerateAnalyticsClusterMemoryEstimateConverter;
import com.oracle.bmc.mysql.internal.http.GenerateHeatWaveClusterMemoryEstimateConverter;
import com.oracle.bmc.mysql.internal.http.GetAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.GetAnalyticsClusterMemoryEstimateConverter;
import com.oracle.bmc.mysql.internal.http.GetDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.GetHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.GetHeatWaveClusterMemoryEstimateConverter;
import com.oracle.bmc.mysql.internal.http.ListDbSystemsConverter;
import com.oracle.bmc.mysql.internal.http.RestartAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.RestartDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.RestartHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.StartAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.StartDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.StartHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.StopAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.StopDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.StopHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.UpdateAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.UpdateDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.UpdateHeatWaveClusterConverter;
import com.oracle.bmc.mysql.requests.AddAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.AddHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.CreateDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.DeleteDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.GenerateAnalyticsClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GenerateHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetAnalyticsClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.GetDbSystemRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.ListDbSystemsRequest;
import com.oracle.bmc.mysql.requests.RestartAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.RestartDbSystemRequest;
import com.oracle.bmc.mysql.requests.RestartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StartAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.StartDbSystemRequest;
import com.oracle.bmc.mysql.requests.StartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StopAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.StopDbSystemRequest;
import com.oracle.bmc.mysql.requests.StopHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.UpdateAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.UpdateDbSystemRequest;
import com.oracle.bmc.mysql.requests.UpdateHeatWaveClusterRequest;
import com.oracle.bmc.mysql.responses.AddAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.AddHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.CreateDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.DeleteDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.GenerateAnalyticsClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GenerateHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetAnalyticsClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.GetDbSystemResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.ListDbSystemsResponse;
import com.oracle.bmc.mysql.responses.RestartAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.RestartDbSystemResponse;
import com.oracle.bmc.mysql.responses.RestartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StartAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.StartDbSystemResponse;
import com.oracle.bmc.mysql.responses.StartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StopAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.StopDbSystemResponse;
import com.oracle.bmc.mysql.responses.StopHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.UpdateAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.UpdateDbSystemResponse;
import com.oracle.bmc.mysql.responses.UpdateHeatWaveClusterResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSystemAsyncClient
implements DbSystemAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DbSystemAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DBSYSTEM").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DbSystemAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DbSystemAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DbSystemAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AddAnalyticsClusterResponse> addAnalyticsCluster(AddAnalyticsClusterRequest request, AsyncHandler<AddAnalyticsClusterRequest, AddAnalyticsClusterResponse> handler) {
        LOG.trace("Called async addAnalyticsCluster");
        AddAnalyticsClusterRequest interceptedRequest = AddAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddAnalyticsClusterResponse> transformer = AddAnalyticsClusterConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AddAnalyticsClusterRequest, AddAnalyticsClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AddAnalyticsClusterRequest, AddAnalyticsClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AddHeatWaveClusterResponse> addHeatWaveCluster(AddHeatWaveClusterRequest request, AsyncHandler<AddHeatWaveClusterRequest, AddHeatWaveClusterResponse> handler) {
        LOG.trace("Called async addHeatWaveCluster");
        AddHeatWaveClusterRequest interceptedRequest = AddHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddHeatWaveClusterResponse> transformer = AddHeatWaveClusterConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AddHeatWaveClusterRequest, AddHeatWaveClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AddHeatWaveClusterRequest, AddHeatWaveClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDbSystemResponse> createDbSystem(CreateDbSystemRequest request, AsyncHandler<CreateDbSystemRequest, CreateDbSystemResponse> handler) {
        LOG.trace("Called async createDbSystem");
        CreateDbSystemRequest interceptedRequest = CreateDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDbSystemResponse> transformer = CreateDbSystemConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDbSystemRequest, CreateDbSystemResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDbSystemRequest, CreateDbSystemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAnalyticsClusterResponse> deleteAnalyticsCluster(DeleteAnalyticsClusterRequest request, AsyncHandler<DeleteAnalyticsClusterRequest, DeleteAnalyticsClusterResponse> handler) {
        LOG.trace("Called async deleteAnalyticsCluster");
        DeleteAnalyticsClusterRequest interceptedRequest = DeleteAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAnalyticsClusterResponse> transformer = DeleteAnalyticsClusterConverter.fromResponse();
        AsyncHandler<DeleteAnalyticsClusterRequest, DeleteAnalyticsClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAnalyticsClusterRequest, DeleteAnalyticsClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDbSystemResponse> deleteDbSystem(DeleteDbSystemRequest request, AsyncHandler<DeleteDbSystemRequest, DeleteDbSystemResponse> handler) {
        LOG.trace("Called async deleteDbSystem");
        DeleteDbSystemRequest interceptedRequest = DeleteDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDbSystemResponse> transformer = DeleteDbSystemConverter.fromResponse();
        AsyncHandler<DeleteDbSystemRequest, DeleteDbSystemResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDbSystemRequest, DeleteDbSystemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteHeatWaveClusterResponse> deleteHeatWaveCluster(DeleteHeatWaveClusterRequest request, AsyncHandler<DeleteHeatWaveClusterRequest, DeleteHeatWaveClusterResponse> handler) {
        LOG.trace("Called async deleteHeatWaveCluster");
        DeleteHeatWaveClusterRequest interceptedRequest = DeleteHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteHeatWaveClusterResponse> transformer = DeleteHeatWaveClusterConverter.fromResponse();
        AsyncHandler<DeleteHeatWaveClusterRequest, DeleteHeatWaveClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteHeatWaveClusterRequest, DeleteHeatWaveClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GenerateAnalyticsClusterMemoryEstimateResponse> generateAnalyticsClusterMemoryEstimate(GenerateAnalyticsClusterMemoryEstimateRequest request, AsyncHandler<GenerateAnalyticsClusterMemoryEstimateRequest, GenerateAnalyticsClusterMemoryEstimateResponse> handler) {
        LOG.trace("Called async generateAnalyticsClusterMemoryEstimate");
        GenerateAnalyticsClusterMemoryEstimateRequest interceptedRequest = GenerateAnalyticsClusterMemoryEstimateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateAnalyticsClusterMemoryEstimateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GenerateAnalyticsClusterMemoryEstimateResponse> transformer = GenerateAnalyticsClusterMemoryEstimateConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<GenerateAnalyticsClusterMemoryEstimateRequest, GenerateAnalyticsClusterMemoryEstimateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GenerateAnalyticsClusterMemoryEstimateRequest, GenerateAnalyticsClusterMemoryEstimateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GenerateHeatWaveClusterMemoryEstimateResponse> generateHeatWaveClusterMemoryEstimate(GenerateHeatWaveClusterMemoryEstimateRequest request, AsyncHandler<GenerateHeatWaveClusterMemoryEstimateRequest, GenerateHeatWaveClusterMemoryEstimateResponse> handler) {
        LOG.trace("Called async generateHeatWaveClusterMemoryEstimate");
        GenerateHeatWaveClusterMemoryEstimateRequest interceptedRequest = GenerateHeatWaveClusterMemoryEstimateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateHeatWaveClusterMemoryEstimateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GenerateHeatWaveClusterMemoryEstimateResponse> transformer = GenerateHeatWaveClusterMemoryEstimateConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<GenerateHeatWaveClusterMemoryEstimateRequest, GenerateHeatWaveClusterMemoryEstimateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GenerateHeatWaveClusterMemoryEstimateRequest, GenerateHeatWaveClusterMemoryEstimateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAnalyticsClusterResponse> getAnalyticsCluster(GetAnalyticsClusterRequest request, AsyncHandler<GetAnalyticsClusterRequest, GetAnalyticsClusterResponse> handler) {
        LOG.trace("Called async getAnalyticsCluster");
        GetAnalyticsClusterRequest interceptedRequest = GetAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAnalyticsClusterResponse> transformer = GetAnalyticsClusterConverter.fromResponse();
        AsyncHandler<GetAnalyticsClusterRequest, GetAnalyticsClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAnalyticsClusterRequest, GetAnalyticsClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAnalyticsClusterMemoryEstimateResponse> getAnalyticsClusterMemoryEstimate(GetAnalyticsClusterMemoryEstimateRequest request, AsyncHandler<GetAnalyticsClusterMemoryEstimateRequest, GetAnalyticsClusterMemoryEstimateResponse> handler) {
        LOG.trace("Called async getAnalyticsClusterMemoryEstimate");
        GetAnalyticsClusterMemoryEstimateRequest interceptedRequest = GetAnalyticsClusterMemoryEstimateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAnalyticsClusterMemoryEstimateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAnalyticsClusterMemoryEstimateResponse> transformer = GetAnalyticsClusterMemoryEstimateConverter.fromResponse();
        AsyncHandler<GetAnalyticsClusterMemoryEstimateRequest, GetAnalyticsClusterMemoryEstimateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAnalyticsClusterMemoryEstimateRequest, GetAnalyticsClusterMemoryEstimateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDbSystemResponse> getDbSystem(GetDbSystemRequest request, AsyncHandler<GetDbSystemRequest, GetDbSystemResponse> handler) {
        LOG.trace("Called async getDbSystem");
        GetDbSystemRequest interceptedRequest = GetDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDbSystemResponse> transformer = GetDbSystemConverter.fromResponse();
        AsyncHandler<GetDbSystemRequest, GetDbSystemResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDbSystemRequest, GetDbSystemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetHeatWaveClusterResponse> getHeatWaveCluster(GetHeatWaveClusterRequest request, AsyncHandler<GetHeatWaveClusterRequest, GetHeatWaveClusterResponse> handler) {
        LOG.trace("Called async getHeatWaveCluster");
        GetHeatWaveClusterRequest interceptedRequest = GetHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHeatWaveClusterResponse> transformer = GetHeatWaveClusterConverter.fromResponse();
        AsyncHandler<GetHeatWaveClusterRequest, GetHeatWaveClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetHeatWaveClusterRequest, GetHeatWaveClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetHeatWaveClusterMemoryEstimateResponse> getHeatWaveClusterMemoryEstimate(GetHeatWaveClusterMemoryEstimateRequest request, AsyncHandler<GetHeatWaveClusterMemoryEstimateRequest, GetHeatWaveClusterMemoryEstimateResponse> handler) {
        LOG.trace("Called async getHeatWaveClusterMemoryEstimate");
        GetHeatWaveClusterMemoryEstimateRequest interceptedRequest = GetHeatWaveClusterMemoryEstimateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHeatWaveClusterMemoryEstimateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHeatWaveClusterMemoryEstimateResponse> transformer = GetHeatWaveClusterMemoryEstimateConverter.fromResponse();
        AsyncHandler<GetHeatWaveClusterMemoryEstimateRequest, GetHeatWaveClusterMemoryEstimateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetHeatWaveClusterMemoryEstimateRequest, GetHeatWaveClusterMemoryEstimateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDbSystemsResponse> listDbSystems(ListDbSystemsRequest request, AsyncHandler<ListDbSystemsRequest, ListDbSystemsResponse> handler) {
        LOG.trace("Called async listDbSystems");
        ListDbSystemsRequest interceptedRequest = ListDbSystemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbSystemsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDbSystemsResponse> transformer = ListDbSystemsConverter.fromResponse();
        AsyncHandler<ListDbSystemsRequest, ListDbSystemsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDbSystemsRequest, ListDbSystemsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RestartAnalyticsClusterResponse> restartAnalyticsCluster(RestartAnalyticsClusterRequest request, AsyncHandler<RestartAnalyticsClusterRequest, RestartAnalyticsClusterResponse> handler) {
        LOG.trace("Called async restartAnalyticsCluster");
        RestartAnalyticsClusterRequest interceptedRequest = RestartAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestartAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestartAnalyticsClusterResponse> transformer = RestartAnalyticsClusterConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RestartAnalyticsClusterRequest, RestartAnalyticsClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RestartAnalyticsClusterRequest, RestartAnalyticsClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RestartDbSystemResponse> restartDbSystem(RestartDbSystemRequest request, AsyncHandler<RestartDbSystemRequest, RestartDbSystemResponse> handler) {
        LOG.trace("Called async restartDbSystem");
        RestartDbSystemRequest interceptedRequest = RestartDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestartDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestartDbSystemResponse> transformer = RestartDbSystemConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RestartDbSystemRequest, RestartDbSystemResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RestartDbSystemRequest, RestartDbSystemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RestartHeatWaveClusterResponse> restartHeatWaveCluster(RestartHeatWaveClusterRequest request, AsyncHandler<RestartHeatWaveClusterRequest, RestartHeatWaveClusterResponse> handler) {
        LOG.trace("Called async restartHeatWaveCluster");
        RestartHeatWaveClusterRequest interceptedRequest = RestartHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestartHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestartHeatWaveClusterResponse> transformer = RestartHeatWaveClusterConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RestartHeatWaveClusterRequest, RestartHeatWaveClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RestartHeatWaveClusterRequest, RestartHeatWaveClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StartAnalyticsClusterResponse> startAnalyticsCluster(StartAnalyticsClusterRequest request, AsyncHandler<StartAnalyticsClusterRequest, StartAnalyticsClusterResponse> handler) {
        LOG.trace("Called async startAnalyticsCluster");
        StartAnalyticsClusterRequest interceptedRequest = StartAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartAnalyticsClusterResponse> transformer = StartAnalyticsClusterConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StartAnalyticsClusterRequest, StartAnalyticsClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StartAnalyticsClusterRequest, StartAnalyticsClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StartDbSystemResponse> startDbSystem(StartDbSystemRequest request, AsyncHandler<StartDbSystemRequest, StartDbSystemResponse> handler) {
        LOG.trace("Called async startDbSystem");
        StartDbSystemRequest interceptedRequest = StartDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartDbSystemResponse> transformer = StartDbSystemConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StartDbSystemRequest, StartDbSystemResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StartDbSystemRequest, StartDbSystemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StartHeatWaveClusterResponse> startHeatWaveCluster(StartHeatWaveClusterRequest request, AsyncHandler<StartHeatWaveClusterRequest, StartHeatWaveClusterResponse> handler) {
        LOG.trace("Called async startHeatWaveCluster");
        StartHeatWaveClusterRequest interceptedRequest = StartHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartHeatWaveClusterResponse> transformer = StartHeatWaveClusterConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StartHeatWaveClusterRequest, StartHeatWaveClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StartHeatWaveClusterRequest, StartHeatWaveClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StopAnalyticsClusterResponse> stopAnalyticsCluster(StopAnalyticsClusterRequest request, AsyncHandler<StopAnalyticsClusterRequest, StopAnalyticsClusterResponse> handler) {
        LOG.trace("Called async stopAnalyticsCluster");
        StopAnalyticsClusterRequest interceptedRequest = StopAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopAnalyticsClusterResponse> transformer = StopAnalyticsClusterConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StopAnalyticsClusterRequest, StopAnalyticsClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StopAnalyticsClusterRequest, StopAnalyticsClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StopDbSystemResponse> stopDbSystem(StopDbSystemRequest request, AsyncHandler<StopDbSystemRequest, StopDbSystemResponse> handler) {
        LOG.trace("Called async stopDbSystem");
        StopDbSystemRequest interceptedRequest = StopDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopDbSystemResponse> transformer = StopDbSystemConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StopDbSystemRequest, StopDbSystemResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StopDbSystemRequest, StopDbSystemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StopHeatWaveClusterResponse> stopHeatWaveCluster(StopHeatWaveClusterRequest request, AsyncHandler<StopHeatWaveClusterRequest, StopHeatWaveClusterResponse> handler) {
        LOG.trace("Called async stopHeatWaveCluster");
        StopHeatWaveClusterRequest interceptedRequest = StopHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopHeatWaveClusterResponse> transformer = StopHeatWaveClusterConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StopHeatWaveClusterRequest, StopHeatWaveClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StopHeatWaveClusterRequest, StopHeatWaveClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAnalyticsClusterResponse> updateAnalyticsCluster(UpdateAnalyticsClusterRequest request, AsyncHandler<UpdateAnalyticsClusterRequest, UpdateAnalyticsClusterResponse> handler) {
        LOG.trace("Called async updateAnalyticsCluster");
        UpdateAnalyticsClusterRequest interceptedRequest = UpdateAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAnalyticsClusterResponse> transformer = UpdateAnalyticsClusterConverter.fromResponse();
        AsyncHandler<UpdateAnalyticsClusterRequest, UpdateAnalyticsClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAnalyticsClusterRequest, UpdateAnalyticsClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDbSystemResponse> updateDbSystem(UpdateDbSystemRequest request, AsyncHandler<UpdateDbSystemRequest, UpdateDbSystemResponse> handler) {
        LOG.trace("Called async updateDbSystem");
        UpdateDbSystemRequest interceptedRequest = UpdateDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDbSystemResponse> transformer = UpdateDbSystemConverter.fromResponse();
        AsyncHandler<UpdateDbSystemRequest, UpdateDbSystemResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDbSystemRequest, UpdateDbSystemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateHeatWaveClusterResponse> updateHeatWaveCluster(UpdateHeatWaveClusterRequest request, AsyncHandler<UpdateHeatWaveClusterRequest, UpdateHeatWaveClusterResponse> handler) {
        LOG.trace("Called async updateHeatWaveCluster");
        UpdateHeatWaveClusterRequest interceptedRequest = UpdateHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateHeatWaveClusterResponse> transformer = UpdateHeatWaveClusterConverter.fromResponse();
        AsyncHandler<UpdateHeatWaveClusterRequest, UpdateHeatWaveClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateHeatWaveClusterRequest, UpdateHeatWaveClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DbSystemAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DbSystemAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DbSystemAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

