/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.mysql.model.HeatWaveCluster;
import com.oracle.bmc.mysql.requests.AddHeatWaveClusterRequest;
import com.oracle.bmc.mysql.responses.AddHeatWaveClusterResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddHeatWaveClusterConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AddHeatWaveClusterConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static AddHeatWaveClusterRequest interceptRequest(AddHeatWaveClusterRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, AddHeatWaveClusterRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getAddHeatWaveClusterDetails(), (String)"addHeatWaveClusterDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190415").path("dbSystems").path(HttpUtils.encodePathSegment((String)request.getDbSystemId())).path("heatWaveCluster").path("actions").path("add");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, AddHeatWaveClusterResponse> fromResponse() {
        Function<Response, AddHeatWaveClusterResponse> transformer = new Function<Response, AddHeatWaveClusterResponse>(){

            public AddHeatWaveClusterResponse apply(Response rawResponse) {
                Optional opcWorkRequestIdHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.mysql.responses.AddHeatWaveClusterResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(HeatWaveCluster.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                AddHeatWaveClusterResponse.Builder builder = AddHeatWaveClusterResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.heatWaveCluster((HeatWaveCluster)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                AddHeatWaveClusterResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

