/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.mysql.requests.UpdateBackupRequest;
import com.oracle.bmc.mysql.responses.UpdateBackupResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateBackupConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateBackupConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateBackupRequest interceptRequest(UpdateBackupRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateBackupRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateBackupDetails(), (String)"updateBackupDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190415").path("backups").path(HttpUtils.encodePathSegment((String)request.getBackupId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, UpdateBackupResponse> fromResponse() {
        Function<Response, UpdateBackupResponse> transformer = new Function<Response, UpdateBackupResponse>(){

            public UpdateBackupResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.mysql.responses.UpdateBackupResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateBackupResponse.Builder builder = UpdateBackupResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                if (response.getStatusCode() != 304) {
                    builder.isNotModified(false);
                } else {
                    builder.isNotModified(true);
                }
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                UpdateBackupResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

