/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetChannelRequest
extends BmcRequest<Void> {
    private String channelId;
    private String opcRequestId;
    private String ifNoneMatch;

    @ConstructorProperties(value={"channelId", "opcRequestId", "ifNoneMatch"})
    GetChannelRequest(String channelId, String opcRequestId, String ifNoneMatch) {
        this.channelId = channelId;
        this.opcRequestId = opcRequestId;
        this.ifNoneMatch = ifNoneMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<GetChannelRequest, Void> {
        private String channelId;
        private String opcRequestId;
        private String ifNoneMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetChannelRequest o) {
            this.channelId(o.getChannelId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetChannelRequest build() {
            GetChannelRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public GetChannelRequest buildWithoutInvocationCallback() {
            return new GetChannelRequest(this.channelId, this.opcRequestId, this.ifNoneMatch);
        }

        public String toString() {
            return "GetChannelRequest.Builder(channelId=" + this.channelId + ", opcRequestId=" + this.opcRequestId + ", ifNoneMatch=" + this.ifNoneMatch + ")";
        }
    }
}

