/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetConfigurationRequest
extends BmcRequest<Void> {
    private String configurationId;
    private String opcRequestId;
    private String ifNoneMatch;

    @ConstructorProperties(value={"configurationId", "opcRequestId", "ifNoneMatch"})
    GetConfigurationRequest(String configurationId, String opcRequestId, String ifNoneMatch) {
        this.configurationId = configurationId;
        this.opcRequestId = opcRequestId;
        this.ifNoneMatch = ifNoneMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConfigurationRequest, Void> {
        private String configurationId;
        private String opcRequestId;
        private String ifNoneMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConfigurationRequest o) {
            this.configurationId(o.getConfigurationId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConfigurationRequest build() {
            GetConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public GetConfigurationRequest buildWithoutInvocationCallback() {
            return new GetConfigurationRequest(this.configurationId, this.opcRequestId, this.ifNoneMatch);
        }

        public String toString() {
            return "GetConfigurationRequest.Builder(configurationId=" + this.configurationId + ", opcRequestId=" + this.opcRequestId + ", ifNoneMatch=" + this.ifNoneMatch + ")";
        }
    }
}

